/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.back.common.util.ExtensionOperationJudge;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseQueryDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.sortcondition.KingBaseSortCondition;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.sortcondition.KingBaseSortConditionField;
import com.jxdinfo.hussar.formdesign.kingbase.function.render.KingBaseBaseRender;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEFLOWConditionFilter")
public class KingBaseFlowConditionFilterVistor
implements KingBaseOperationVisitor<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseFlowConditionFilterVistor.class);
    public static final String OPERATION_NAME = "KINGBASEFLOWConditionFilter";

    @Override
    public void visit(KingBaseBackCtx<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        KingBaseFlowDataModel kingbaseBaseDataModel = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = kingbaseBaseDataModel.getLogicallyDelete();
        KingBaseFlowDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String type = ExtensionOperationJudge.type(dataModelOperation.getParams());
        if (HussarUtils.equals((Object)ExtensionOperationJudge.REUSED, (Object)type)) {
            this.addApi(backCtx, dataModelOperation, dataModelBaseDTO, "${PREFIX.standardName}");
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, kingbaseBaseDataModel);
        KingBaseDataModelFieldDto fieldDto = dataModelBaseDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto.getPropertyName());
            hasSecurityLevel = true;
        }
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        this.renderFilter(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        boolean isSortCondition = this.renderSort(dataModelOperation, controllerParams, kingbaseBaseDataModel);
        boolean isSortOverall = true;
        controllerParams.put("isSortOverall", isSortOverall);
        if (isLogicallyDelete) {
            controllerParams.put("deleteFlag", dataModelBaseDTO.getFieldCapitalName(kingbaseBaseDataModel.getDeleteFlag().getName()));
            controllerParams.put("deleteFlagName", kingbaseBaseDataModel.getDeleteFlag().getSourceFieldName());
        }
        controllerParams.put("deploymentMode", AppContextUtil.isHTSZMode());
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/kingbase/backcode/conditionFilter/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/kingbase/backcode/conditionFilter/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/kingbase/backcode/conditionFilter/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSortOverall, isSortCondition, hasSecurityLevel);
        this.addApi(backCtx, dataModelOperation, dataModelBaseDTO, "${PREFIX.name}");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void addApi(KingBaseBackCtx<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation, KingBaseFlowDataModelDTO dataModelBaseDTO, String prefix) throws LcdpException {
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(prefix) + "/" + dataModelOperation.getName(), "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2");
        String modelId = backCtx.getUseDataModelBase().getId();
        backCtx.addApi(modelId, KingBaseBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private Map<String, Object> initParams(KingBaseDataModelOperation dataModelOperation, KingBaseBaseDataModelDTO dataModelBaseDTO, KingBaseBaseDataModel kingbaseBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        boolean isLogicallyDelete = kingbaseBaseDataModel.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void renderImport(KingBaseBackCtx<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> backCtx, String modelId, KingBaseBaseDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSortOverall, boolean isSortCondition, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (backCtx.getUseDataModelBase().getLogicallyDelete()) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
        if (isSortCondition) {
            if (isPagination) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
    }

    private boolean renderSort(KingBaseDataModelOperation dataModelOperation, Map<String, Object> templateParams, KingBaseBaseDataModel useDataModelBase) throws LcdpException {
        KingBaseSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && HussarUtils.isNotEmpty((Object)(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName))) && Optional.of(sortCondition).map(KingBaseSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<KingBaseSortConditionField> sortConditionFields = sortCondition.getFields();
            for (KingBaseSortConditionField sortConditionField : sortConditionFields) {
                sortConditionField.replaceFieldName();
            }
            templateParams.put("sortConditionObj", sortCondition);
            templateParams.put("isSortCondition", true);
            return true;
        }
        return false;
    }

    private boolean renderFilter(KingBaseBackCtx<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation, String modelId, KingBaseBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("showFilter"));
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        controllerParams.put("showFilter", true);
        KingBaseQueryDTO queryDTO = KingBaseDataModelUtil.getFilterDto(dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(queryDTO);
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private void renderPageVo(KingBaseBackCtx<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> backCtx, String modelId, KingBaseBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        KingBaseDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

