/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.masterslave.extension;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEMASTER_SLAVEextensionSlaveQueryPlus")
public class KingBaseMsExtensionSlaveQueryPlusVisitor
implements KingBaseOperationVisitor<KingBaseMsDataModel, KingBaseMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseMsExtensionSlaveQueryPlusVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEMASTER_SLAVEextensionSlaveQueryPlus";

    @Override
    public void visit(KingBaseBackCtx<KingBaseMsDataModel, KingBaseMsDataModelDTO> backCtx, KingBaseDataModelOperation operation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        KingBaseMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        KingBaseMsDataModelDTO kingbaseMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", kingbaseMsDataModelDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        List<KingBaseDataModelBase> extendSlaveTables = KingBaseMsExtensionSlaveQueryPlusVisitor.getSlaveArrayTables(kingbaseMsDataModelDTO, dataModelBase);
        if (extendSlaveTables.isEmpty()) {
            return;
        }
        controllerParams.put("extendSlaveTable", extendSlaveTables);
        HashMap<String, String> slaveTableValueNames = new HashMap<String, String>();
        for (KingBaseDataModelBase slaveTable : extendSlaveTables) {
            String slaveTableValueName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)slaveTable.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
            slaveTableValueNames.put(slaveTable.getId(), slaveTableValueName);
        }
        controllerParams.put("slaveTableValueNames", slaveTableValueNames);
        String serviceImplPath = "template/kingbase/masterslavebackcode/extension/slaveQueryPlus/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplInversion(modelId, kingbaseMsDataModelDTO.getMapperName());
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<KingBaseDataModelBase> getSlaveArrayTables(KingBaseMsDataModelDTO dataModelBaseDTO, KingBaseMsDataModel dataModelBase) {
        CopyOnWriteArrayList<KingBaseDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<KingBaseDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (KingBaseDataModelBase slaveArrayTable : slaveArrayTables) {
            if (!slaveArrayTable.isExtension()) {
                slaveArrayTables.remove(slaveArrayTable);
                continue;
            }
            for (KingBaseRelationshipDTO relationshipDTO : dataModelBaseDTO.getRelationshipDtoList()) {
                if (!"association".equals(relationshipDTO.getRelateModelType()) || !slaveArrayTable.getId().equals(relationshipDTO.getSlaveTableId())) continue;
                slaveArrayTables.remove(slaveArrayTable);
                continue block0;
            }
        }
        for (KingBaseDataModelBase slaveArrayTable : slaveArrayTables) {
            boolean flag = false;
            for (KingBaseDataModelOperation operation : dataModelBase.getOperations()) {
                if (!slaveArrayTable.getId().equals(operation.getParams().get("slaveModelId")) || !operation.getType().equals("SlaveQuery")) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            slaveArrayTables.remove(slaveArrayTable);
        }
        return slaveArrayTables;
    }
}

