/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.masterslave;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEMASTER_SLAVESerialNumber")
public class KingBaseMsSerialNumberVisitor
implements KingBaseOperationVisitor<KingBaseMsDataModel, KingBaseMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseMsSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEMASTER_SLAVESerialNumber";

    @Override
    public void visit(KingBaseBackCtx<KingBaseMsDataModel, KingBaseMsDataModelDTO> backCtx, KingBaseDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        KingBaseMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        KingBaseMsDataModelDTO kingbaseMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Optional<KingBaseDataModelFieldDto> serialFieldOpt = kingbaseMsDataModelDTO.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        KingBaseDataModelBase masterTable = dataModelBase.getMasterTable();
        Map<String, KingBaseDataModelBaseDTO> dataModelDtoMap = kingbaseMsDataModelDTO.getDataModelDtoMap();
        KingBaseDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", mainDataModelDto);
        params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        KingBaseDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("returnValue", mainDataModelDto.getEntityName());
        kingbaseMsDataModelDTO.addServiceImplImport(mainDataModelDto.getImportInfo().get("Entity"));
        kingbaseMsDataModelDTO.addServiceImport(mainDataModelDto.getImportInfo().get("Entity"));
        kingbaseMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        kingbaseMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        kingbaseMsDataModelDTO.addServiceImplImport("java.util.HashMap");
        kingbaseMsDataModelDTO.addServiceImplImport("java.util.Map");
        kingbaseMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        kingbaseMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        kingbaseMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        kingbaseMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        kingbaseMsDataModelDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        kingbaseMsDataModelDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        backCtx.addServiceImplInversion(dataModelBase.getId(), "ISysCodeRuleService");
        String implPath = "template/kingbase/masterslavebackcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/kingbase/masterslavebackcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSON.toJSONString((Object)masterTable)), masterTable.getComment(), masterTable.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

