/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEFLOW_MASTER_SLAVESerialNumber")
public class KingBaseMsFlowSerialNumberVisitor
implements KingBaseOperationVisitor<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseMsFlowSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEFLOW_MASTER_SLAVESerialNumber";

    @Override
    public void visit(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> flowBackCtx, KingBaseDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = flowBackCtx.getUseDataModelBase().getId();
        KingBaseFlowMsDataModelDTO kingbaseFlowMsDataModelDTO = flowBackCtx.getUseDataModelDtoMap().get(modelId);
        KingBaseFlowMsDataModel dataModelBase = flowBackCtx.getUseDataModelBase();
        KingBaseBackCtx backCtx = new KingBaseBackCtx();
        backCtx.setUseDataModelBase(dataModelBase);
        HashMap<String, KingBaseFlowMsDataModelDTO> map = new HashMap<String, KingBaseFlowMsDataModelDTO>();
        map.put(modelId, kingbaseFlowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, KingBaseDataModelBaseDTO> dataModelDtoMap = kingbaseFlowMsDataModelDTO.getDataModelDtoMap();
        KingBaseDataModelBase masterTable = dataModelBase.getMasterTable();
        KingBaseDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        Optional<KingBaseDataModelFieldDto> serialFieldOpt = mainDataModelDto.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        if (HussarUtils.isEmpty(operation.getParams())) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", mainDataModelDto);
        params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        KingBaseDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("parameter", kingbaseFlowMsDataModelDTO.getQueryDtoMap().get(kingbaseFlowMsDataModelDTO.getName()).getEntityName());
        params.put("returnValue", mainDataModelDto.getEntityName());
        kingbaseFlowMsDataModelDTO.addServiceImplImport(mainDataModelDto.getImportInfo().get("Entity"));
        kingbaseFlowMsDataModelDTO.addServiceImport(mainDataModelDto.getImportInfo().get("Entity"));
        kingbaseFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("java.util.HashMap");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("java.util.Map");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        kingbaseFlowMsDataModelDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        backCtx.addServiceImplInversion(((KingBaseFlowMsDataModel)backCtx.getUseDataModelBase()).getId(), "ISysCodeRuleService");
        String implPath = "template/kingbase/flowbackcode/masterslaveflowbackcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/kingbase/flowbackcode/masterslaveflowbackcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSON.toJSONString((Object)masterTable)), masterTable.getComment(), masterTable.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

