<#assign index = 0>
@Override
<#list annotations! as annotation>
    ${annotation}
</#list>
public void  ${name!}(Object obj){
    try {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(obj));
        Map<String,Object>  extensionMap = jsonObject.getObject("expansionMap", Map.class);
        if (HussarUtils.isEmpty(extensionMap)) {
            return;
        }
        Long businessId = jsonObject.getLong("${primaryField?uncap_first}");
    <#--    所有关联关系-->
    <#list table.relationshipDtoList as rs>
        <#if !extendModelIds?seq_contains(rs.slaveTableId)>
            <#-- 跳过当前循环，不执行后续逻辑 -->
        <#else>
            <#--    一对多 -->
            <#if rs.relateModelType == 'collection'>
                <#-- 增量生成-->
                <#if slaveTablePlusSave?? && slaveTablePlusSave[rs.slaveTableId]?? && slaveTablePlusSave[rs.slaveTableId]>
                    // ${rs.slaveTableName}增量
                    <#assign genericType = "Increment<" + rs.slaveTableName + ">">
                    Increment<${rs.slaveTableName}> ${rs.slaveTableAlias}Slave = JSON.parseObject(JSON.toJSONString(extensionMap.get("${rs.slaveTableAlias}")), new TypeReference<${genericType}>() {}  );
                    if(HussarUtils.isNotEmpty(${rs.slaveTableAlias}Slave)){
                            List<${rs.slaveTableName}> ${rs.slaveTableAlias}Del = ${rs.slaveTableAlias}Slave.getDel();
                            <#if !(isLogicallyDelete??) || !(isLogicallyDelete[rs.slaveTableId]??) || !isLogicallyDelete[rs.slaveTableId]>
                                if (HussarUtils.isNotEmpty(${rs.slaveTableAlias}Del)) {
                                // 删除
                                LambdaQueryWrapper<${rs.slaveTableName}> ew0 = new LambdaQueryWrapper<>();
                                ew0.in(${rs.slaveTableName}::get${primaryKeys[rs.slaveTableAlias]}, ${rs.slaveTableAlias}Del.stream().map(${rs.slaveTableName}::get${primaryKeys[rs.slaveTableAlias]}).collect(Collectors.toList()));
                                /* @begin ${name!}${index!}1 #自定义代码 */
                                /* @end ${name!}${index!}1 */
                                ${rs.slaveTableServiceName}.remove(ew0);
                                }
                            <#else>
                                if (HussarUtils.isNotEmpty(${rs.slaveTableAlias}Del)) {
                                    for (${rs.slaveTableName}  ${rs.slaveTableAlias} : ${rs.slaveTableAlias}Del) {
                                        ${rs.slaveTableAlias}.set${logicallyDelField[rs.slaveTableAlias]?cap_first}("1");
                                    }
                                }
                            </#if>
                            // 新增或修改
                            List<${rs.slaveTableName}> ${rs.slaveTableAlias}AddOrUpdate = new ArrayList<>();
                            List<${rs.slaveTableName}> ${rs.slaveTableAlias}Add = ${rs.slaveTableAlias}Slave.getAdd();
                            List<${rs.slaveTableName}> ${rs.slaveTableAlias}Edit = ${rs.slaveTableAlias}Slave.getEdit();
                            <#if isLogicallyDelete?? && isLogicallyDelete[rs.slaveTableId] && isLogicallyDelete[rs.slaveTableId]>
                                if (HussarUtils.isNotEmpty(${rs.slaveTableAlias}Del)) {
                                    ${rs.slaveTableAlias}AddOrUpdate.addAll(${rs.slaveTableAlias}Del);
                                }
                            </#if>
                            if (HussarUtils.isNotEmpty(${rs.slaveTableAlias}Add)) {
                                ${rs.slaveTableAlias}AddOrUpdate.addAll(${rs.slaveTableAlias}Add);
                            }
                            if (HussarUtils.isNotEmpty(${rs.slaveTableAlias}Edit)) {
                                ${rs.slaveTableAlias}AddOrUpdate.addAll(${rs.slaveTableAlias}Edit);
                            }
                            for (${rs.slaveTableName} ${rs.slaveTableName?uncap_first} : ${rs.slaveTableAlias}AddOrUpdate) {
                                ${rs.slaveTableName?uncap_first}.set${foreignKeys[rs.slaveTableAlias]}(businessId);
                                <#if relationTagKeys?? && rs.slaveTableAlias?? && relationTagKeys[rs.slaveTableAlias]??>
                                    ${rs.slaveTableName?uncap_first}.set${relationTagKeys[rs.slaveTableAlias]}("${rs.slaveTableAlias}");
                                </#if>
                                <#-- 子表填充-->
                                ${slaveFillCodeList[rs.slaveTableId]!}
                            }
                            /* @begin ${name!}${index!}2 #自定义代码 */
                            /* @end ${name!}${index!}2 */
                            ${rs.slaveTableServiceName}.saveOrUpdateBatch(${rs.slaveTableAlias}AddOrUpdate);
                    }

                <#else>
                    <#--    非增量生成-->
                    <#--    子表模型dto-->
                        <#assign slaveDto = rs.slaveTableDto>
                    <#--    查询对象变量命名ew0、ew1-->
                        <#assign wrapperObj = 'ew${index}'>
                        // ${slaveDto.entityName}非增量
                        LambdaQueryWrapper<${slaveDto.entityName}> ${wrapperObj} = new LambdaQueryWrapper<>();
                    <#--    遍历关联关系详情配置查询条件-->
                        <#list rs.relationshipDtoList! as rsDetails>
                            ${wrapperObj}.eq(${slaveDto.entityName}::get${rsDetails.slaveFieldCap},
                            <#if rsDetails.mode == 'input'>
                                ${rsDetails.mainField!}
                            <#else>
                                businessId
                            </#if>);
                        </#list>
                        <#if relationTagKeys?? && rs.slaveTableAlias?? && relationTagKeys[rs.slaveTableAlias]??>
                            ${wrapperObj}.eq(${slaveDto.entityName}::get${relationTagKeys[rs.slaveTableAlias]}, "${slaveDto.entityName?uncap_first}");
                        </#if>
                        /* @begin ${name!}${index!}1 #自定义代码 */
                        /* @end ${name!}${index!}1 */
                        ${slaveDto.serviceEnName!}.remove(${wrapperObj});
                    <#assign slaveObjs = slaveDto.EName + 's'>
                        List<${slaveDto.entityName}> ${slaveObjs} = JSON.parseArray(JSON.toJSONString(extensionMap.get("${rs.slaveTableAlias}")),${slaveDto.entityName}.class);
                        if(HussarUtils.isNotEmpty(${slaveObjs})){
                    <#--        for循环变量名-->
                        <#assign slaveObj = slaveDto.EName>
                        for(${slaveDto.entityName} ${slaveObj} : ${slaveObjs}){
                    <#--    遍历关联关系详情set关联关系值-->
                        <#list rs.relationshipDtoList! as rsDetails>
                            ${slaveObj}.set${rsDetails.slaveFieldCap}(
                            <#if rsDetails.mode == 'input'>
                                ${rsDetails.mainField!}
                            <#else>
                                businessId
                            </#if>);
                        </#list>
                        <#if relationTagKeys?? && rs.slaveTableAlias?? && relationTagKeys[rs.slaveTableAlias]??>
                            ${slaveObj}.set${relationTagKeys[rs.slaveTableAlias]}("${rs.slaveTableAlias}");
                        </#if>
                    <#-- 子表填充-->
                        <#if rs.slaveTableFillCode??>
                            ${rs.slaveTableFillCode!}
                        </#if>
                        }
                        /* @begin ${name!}${index!}2 #自定义代码 */
                        /* @end ${name!}${index!}2 */
                        ${slaveDto.serviceEnName!}.saveOrUpdateBatch(${slaveObjs});
                        }
                </#if>
            <#--    一对一 -->
            <#else>
                <#--    子表模型dto-->
                <#assign slaveDto = rs.slaveTableDto>
                <#assign slaveObj = slaveDto.EName>
                ${slaveDto.entityName} ${slaveDto.EName} = HussarUtils.copy(extensionMap,${slaveDto.entityName}.class);
                if(HussarUtils.isNotEmpty(${slaveDto.EName})){
                <#list rs.relationshipDtoList! as rsDetails>
                    ${slaveObj}.set${rsDetails.slaveFieldCap}(
                    <#if rsDetails.mode == 'input'>
                        ${rsDetails.mainField!}
                    <#else>businessId</#if>);
                </#list>
                <#if relationTagKeys?? && rs.slaveTableAlias?? && relationTagKeys[rs.slaveTableAlias]??>
                    ${rs.slaveTableAlias}.set${relationTagKeys[rs.slaveTableAlias]}("${rs.slaveTableAlias}");
                </#if>
                <#if rs.slaveTableFillCode??>
                    ${rs.slaveTableFillCode!}
                </#if>
                /* @begin ${name!}${index!}1 #自定义代码 */
                /* @end ${name!}${index!}1 */
                ${slaveDto.serviceEnName!}.saveOrUpdate(${slaveDto.EName});
                }
            </#if>
        </#if>
        <#--  每个关联关系查询对象变量Wrapper变量名后缀+1-->
        <#assign index++>
    </#list>
    } catch (Exception e) {
        e.printStackTrace();
    }
}