<#assign index = 0>
/**
* ${exegesis}
*/
@Override
public ApiResponse<String> ${name!}(MultipartFile file, Long taskId, String templateId){
    InputStream input;
    String fileName;
    try {
        input= file.getInputStream(); //将文件转为流
        fileName = file.getOriginalFilename();
    } catch (IOException e) {
        throw new HussarException(e);
    }
    List<${masterTable.entityName}> ${masterTable.EName!}List = new ArrayList<>();
    <#--    所有关联关系-->
    <#list table.relationshipDtoList as rs>
        <#assign slaveDto = rs.slaveTableDto>
        <#--    一对多 -->
        <#if rs.relateModelType == 'collection'>
            List<${slaveDto.entityName}> ${slaveDto.EName!}List = new ArrayList<>();
        <#--    一对一 -->
        <#else>
            <#assign slaveObj = slaveDto.EName>
            List<${slaveDto.entityName}> ${slaveDto.EName}List = new ArrayList<>();
        </#if>
    </#list>
    // 获取当前用户
    SecurityUser user = BaseSecurityUtil.getUser();
    //开启异步，可通过taskId查询异步进程中的任务状态
    Executor hussarBaseExcelExecutor = hussarThreadPoolConfiguration.getAsyncExecutor();
    hussarBaseExcelExecutor.execute(() -> {
        <#-- 读取文件并校验  -->
        List<${returnValue}> importData = VerifyExcelUtil.readInputStreamCheckExcel(user, fileName, input, templateId, taskId);
        if(ToolUtil.isNotEmpty(importData)) {
            for (${returnValue} ${table.entityName?uncap_first} : importData) {
                // 主表增改
                ${masterTable.entityName!} ${masterTable.EName!} = ${table.EName}.gain${masterTable.entityName!}();
                <#-- 主表填充-->
                ${masterFillCode!}
                /* @begin ${name!} #自定义代码 */
                /* @end ${name!} */
                ${masterTable.EName!}List.add(${masterTable.EName!});
                <#--    所有关联关系-->
                <#list table.relationshipDtoList as rs>
                <#--    一对多 -->
                <#if rs.relateModelType == 'collection'>
                    <#assign slaveDto = rs.slaveTableDto>
                    <#-- 从表增改-->
                    <#assign slaveObjs = slaveDto.EName + 's'>
                    List<${slaveDto.entityName}> ${slaveObjs} = ${table.EName!}.gain${rs.slaveTableAlias?cap_first}Array();
                    if(null != ${slaveObjs}){
                        <#--        for循环变量名-->
                        <#assign slaveObj = slaveDto.EName>
                        for(${slaveDto.entityName} ${slaveObj} : ${slaveObjs}){
                            <#--    遍历关联关系详情set关联关系值-->
                            <#list rs.relationshipDtoList! as rsDetails>
                            ${slaveObj}.set${rsDetails.slaveFieldCap}(
                            <#if rsDetails.mode == 'input'>
                                ${rsDetails.mainField!}
                            <#else>
                                ${masterTable.EName!}.get${rsDetails.masterFieldCap}()
                            </#if>);
                            </#list>
                            <#if relationTagKeys?? && rs.slaveTableAlias?? && relationTagKeys[rs.slaveTableAlias]??>
                                ${slaveObj}.set${relationTagKeys[rs.slaveTableAlias]}("${rs.slaveTableAlias}");
                            </#if>
                            <#-- 子表填充-->
                            <#if rs.slaveTableFillCode??>
                                ${rs.slaveTableFillCode!}
                            </#if>
                        }
                        ${slaveDto.EName!}List.addAll(${slaveObjs});
                    }
                <#--    一对一 -->
                <#else>
                    <#--    子表模型dto-->
                    <#assign slaveDto = rs.slaveTableDto>
                    <#assign slaveObj = slaveDto.EName>
                    ${slaveDto.entityName} ${slaveDto.EName} = ${table.EName!}.gain${slaveDto.entityName!}();
                    if(null != ${slaveDto.EName}){
                    <#list rs.relationshipDtoList! as rsDetails>
                    ${slaveObj}.set${rsDetails.slaveFieldCap}(
                        <#if rsDetails.mode == 'input'>
                            ${rsDetails.mainField!}
                        <#else>
                            ${masterTable.EName!}.get${rsDetails.masterFieldCap}()
                        </#if>);
                    </#list>
                    <#if relationTagKeys?? && rs.slaveTableAlias?? && relationTagKeys[rs.slaveTableAlias]??>
                        ${rs.slaveTableAlias}.set${relationTagKeys[rs.slaveTableAlias]}("${rs.slaveTableAlias}");
                    </#if>
                    <#if rs.slaveTableFillCode??>
                        ${rs.slaveTableFillCode!}
                    </#if>
                    /* @begin ${name!}${index!}1 #自定义代码 */
                    /* @end ${name!}${index!}1 */
                    ${slaveDto.EName!}List.add(${slaveDto.EName!});
                }
                </#if>
                <#--  每个关联关系查询对象变量Wrapper变量名后缀+1-->
                <#assign index++>
                </#list>
            }
            SysExcelTask excelTask = iSysExcelTaskService.getById(taskId);
            try {
                if(ToolUtil.isNotEmpty(${masterTable.EName!}List)){
                    ${masterTable.EName!}Service.saveOrUpdateBatch(${masterTable.EName!}List);
                }
                <#--    所有关联关系-->
                <#list table.relationshipDtoList as rs>
                    <#assign slaveDto = rs.slaveTableDto>
                    if(ToolUtil.isNotEmpty(${slaveDto.EName!}List)){
                        ${slaveDto.serviceEnName!}.saveOrUpdateBatch(${slaveDto.EName!}List);
                    }
                </#list>
                excelTask.setTaskStatus(TaskConstants.TASK_STATUS_IMPORT_SUCCEED);
                excelTask.setDataSuccess(importData.size());
                excelTask.setDataError(0);
                excelTask.setLastTime(LocalDateTime.now());
                excelTask.setLastEditor(user.getId());
                iSysExcelTaskService.updateById(excelTask);
            }catch (Exception e) {
                excelTask.setTaskStatus(TaskConstants.TASK_STATUS_IMPORT_FAILED);
                excelTask.setDataSuccess(0);
                excelTask.setDataError(importData.size());
                excelTask.setLastTime(LocalDateTime.now());
                excelTask.setLastEditor(user.getId());
                iSysExcelTaskService.updateById(excelTask);
                throw new HussarException("导入失败", e);
            }
        }
    });
    return ApiResponse.success();
}