/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.flow.masterslaveflow.extension;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEFLOW_MASTER_SLAVEextensionQuery")
public class KingBaseMsFlowExtensionQueryVisitor
implements KingBaseOperationVisitor<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseMsFlowExtensionQueryVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEFLOW_MASTER_SLAVEextensionQuery";

    @Override
    public void visit(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, KingBaseDataModelOperation operation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        KingBaseMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        KingBaseFlowMsDataModelDTO kingbaseFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", kingbaseFlowMsDataModelDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        List<KingBaseDataModelBase> extendSlaveTables = KingBaseMsFlowExtensionQueryVisitor.getSlaveArrayTables(kingbaseFlowMsDataModelDTO, dataModelBase);
        controllerParams.put("extendSlaveTable", extendSlaveTables);
        HashMap<String, String> slaveTableValueNames = new HashMap<String, String>();
        for (KingBaseDataModelBase kingBaseDataModelBase : extendSlaveTables) {
            String slaveTableValueName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)kingBaseDataModelBase.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
            slaveTableValueNames.put(kingBaseDataModelBase.getId(), slaveTableValueName);
        }
        controllerParams.put("slaveTableValueNames", slaveTableValueNames);
        HashMap<String, String> slaveTableForeign = new HashMap<String, String>();
        for (KingBaseDataModelBase slaveTable : extendSlaveTables) {
            for (KingBaseDataModelField field : slaveTable.getFields()) {
                if (!"foreign".equals(field.getUsage())) continue;
                slaveTableForeign.put(slaveTable.getId(), field.getName());
            }
        }
        controllerParams.put("slaveTableForeign", slaveTableForeign);
        String string = "template/kingbase/masterslavebackcode/extension/slaveQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<KingBaseDataModelBase> getSlaveArrayTables(KingBaseMsDataModelDTO dataModelBaseDTO, KingBaseMsDataModel dataModelBase) {
        CopyOnWriteArrayList<KingBaseDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<KingBaseDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (KingBaseDataModelBase slaveArrayTable : slaveArrayTables) {
            if (!slaveArrayTable.isExtension()) {
                slaveArrayTables.remove(slaveArrayTable);
                continue;
            }
            for (KingBaseRelationshipDTO relationshipDTO : dataModelBaseDTO.getRelationshipDtoList()) {
                if (!"association".equals(relationshipDTO.getRelateModelType()) || !slaveArrayTable.getId().equals(relationshipDTO.getSlaveTableId())) continue;
                slaveArrayTables.remove(slaveArrayTable);
                continue block0;
            }
        }
        return slaveArrayTables;
    }
}

