/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.render;

import com.jxdinfo.hussar.formdesign.common.constant.path.PathEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.project.scenes.MicroService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.KingBaseCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseRender;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.baseapi.KingBaseBaseApiDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEBASE_APIRENDER")
public class KingBaseBaseApiRender
implements KingBaseRender<KingBaseBaseApiDataModel, KingBaseBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseBaseApiRender.class);
    public static final String RENDER = "KINGBASEBASE_APIRENDER";

    @Override
    public List<KingBaseCodeGenerateInfo> renderCode(KingBaseBackCtx<KingBaseBaseApiDataModel, KingBaseBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<KingBaseCodeGenerateInfo> kingBaseCodeGenerateInfos = new ArrayList<KingBaseCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        MicroService microService = (MicroService)SpringContextUtil.getBean(MicroService.class);
        if (HussarUtils.equals((Object)"dict", (Object)modelId) && HussarUtils.equals((Object)microService.scene(), (Object)PathEnum.FRONT_SINGLE_BACK_SINGLE.getScene())) {
            return kingBaseCodeGenerateInfos;
        }
        BaseFile baseFile = backCtx.getBaseFile();
        KingBaseBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        kingBaseCodeGenerateInfos.add(this.genApiCode(dataModelBaseDTO, baseFile));
        return kingBaseCodeGenerateInfos;
    }

    private KingBaseCodeGenerateInfo genApiCode(KingBaseBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dataModelDto);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }
}

