<#escape x as x!"">
package ${modelName};

import com.jxdinfo.hussar.formdesign.formdesign.visitor.HussarBpmVariablesVisitor;
<#if params??>
<#list params.imports! as import>
import ${import!};
</#list>
</#if>
import org.springframework.stereotype.Component;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
<#--遍历引入包，添加对应包到生成代码中-->
    <#if importClassNames?? && (importClassNames?size >0)>
        <#list importClassNames as importClassName>
import ${importClassName};
        </#list>

import javax.annotation.Resource;
    </#if>
import java.util.HashMap;
import java.util.Map;

<#if instanceKey != "" >
    @Component(value = "${componentId}")
    public class ${identityKey?replace("_","")?cap_first?replace("-","")?replace(":","")}Visitor implements HussarBpmVariablesVisitor {
<#else >
    @Component(value = "${componentId}")
    public class ${identityKey?replace("_","")?cap_first?replace("-","")?replace(":","")}Visitor implements HussarBpmVariablesVisitor {
</#if>

<#--遍历表名，表名+Service组成方法名，引入对应方法依赖-->
<#if tableNames != ''>
    @Resource
<#if dataType == "TASK" || dataType == "TASK_MASTER_SLAVE">
    private ${tableNames?cap_first}Service ${tableNames?uncap_first}Service;
<#else>
    private ${tableNames?cap_first}Service ${tableNames?uncap_first}Service;
</#if>
</#if>

    @Override
    public Map${r'<String,'} Object> visit(String businessId) {
<#--遍历表名，表名作为对象类名，查询方法默认均使用了businessId  select不能放下面的那个循环，因为会增加查询次数-->
<#if tableNames != ''>
        //查询所需对象
    <#if params.isPlusQuery?? && params.isPlusQuery>
         ${params.PageDTO!} pageDTO = new ${params.PageDTO!}();
         pageDTO.setId(${params.primaryType!}.valueOf(businessId));
         ${params.returnValue!} ${tableNames?uncap_first} = ${tableNames?uncap_first}Service.formQueryPlus(pageDTO).getData();
         ${tableNames?uncap_first} = ${tableNames?uncap_first} != null ? ${tableNames?uncap_first} : new ${params.returnValue!}();
    <#else>
        <#if priType == 'Long'>
            ${tableNames?cap_first} ${tableNames?uncap_first} = ${tableNames?uncap_first}Service.formQuery(Long.valueOf(businessId)).getData();
        <#else >
            ${tableNames?cap_first} ${tableNames?uncap_first} = ${tableNames?uncap_first}Service.formQuery(businessId).getData();
        </#if>
        ${tableNames?uncap_first} = ${tableNames?uncap_first} != null ? ${tableNames?uncap_first} : new ${tableNames?cap_first}();
    </#if>
</#if>
        //将所找属性放到map中传递
        Map${r'<String,'} Object> map = new HashMap<>();
<#--遍历属性名、字段名、表名组 属性名作为key表名作为对象，。get字段名（驼峰）作为方法获取对应值-->
<#if tableServerModels?? && (tableServerModels?size >0)>
    <#if securityLevelField??>
        map.put(BpmConstant.ANNOTATION_SECURITY_LEVEL_ATTRIBUTE,"${securityLevelField}");
    </#if>
<#list tableServerModels as tableServerModel>
    <#if tableServerModel.tableName != "" && tableNames?? && tableNames != ''>
        <#if tableServerModel.varType == "ArrayPrimary">
        if(HussarUtils.isNotEmpty(${tableNames?uncap_first}.${tableServerModel.getName})) {
            map.put("${tableServerModel.selectName}",Arrays.asList(${tableNames?uncap_first}.${tableServerModel.getName}.split(",")));
        }else {
            map.put("${tableServerModel.selectName}",${tableNames?uncap_first}.${tableServerModel.getName});
        }
        <#else>
        map.put("${tableServerModel.selectName}",${tableNames?uncap_first}.${tableServerModel.getName});
        </#if>
    <#else >
        map.put("${tableServerModel.selectName}",null);
    </#if>
</#list>
</#if>
        return map;
    }
}
</#escape>
