/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.processor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.kingbase.code.KingBaseCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseModelFunction;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseRender;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.result.KingBaseCodeResult;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseDataModelUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KingBaseModelProcessor
implements DataModelProcessor<KingBaseCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(KingBaseModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"KINGBASE", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<KingBaseCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx = this.getKingBaseBackCtx(publishCtx);
        KingBaseModelProcessor.init(backCtx, dataModelBase);
        KingBaseModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    public void generateForExt(PublishCtx<KingBaseCodeResult> context, JSONObject dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx = this.getKingBaseBackCtx(context);
        KingBaseModelProcessor.init(backCtx, dataModelBase);
        KingBaseModelProcessor.generateSingleModel(backCtx, context);
        context.setPublishDTO(backCtx.getPublishDTO());
    }

    private KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> getKingBaseBackCtx(PublishCtx<KingBaseCodeResult> publishCtx) {
        KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx = new KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx, JSONObject dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        KingBaseDataModelBase currentModelBase = KingBaseDataModelUtil.transfer(dataModelBase);
        KingBaseModelFunction currentFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(currentModelBase.getFunctionType());
        String modelId = currentModelBase.getId();
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, KingBaseDataModelBaseDTO> useDtoMap = new HashMap<String, KingBaseDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void init(KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        KingBaseModelFunction currentFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        KingBaseDataModelBase currentModelBase = KingBaseDataModelUtil.transfer(dataModelBase);
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, KingBaseDataModelBaseDTO> useDtoMap = new HashMap<String, KingBaseDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx, PublishCtx<KingBaseCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        KingBaseModelProcessor.visit(backCtx);
        KingBaseModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        KingBaseDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        KingBaseDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PageInfoNode pageInfoNode = null;
        if (backCtx.getUseDataModelBase().getIsPublishResource()) {
            pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        }
        if (HussarUtils.isEmpty(useDataModelBase.getOperations())) {
            useDataModelBase.customOption(backCtx);
            return;
        }
        for (KingBaseDataModelOperation operation : useDataModelBase.getOperations()) {
            KingBaseOperationVisitor<KingBaseDataModelBase, KingBaseDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("KINGBASE", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            try {
                backCtx.getModelFunction().accept(visitor, backCtx, operation);
            }
            catch (Exception var) {
                logger.error("\u6a21\u578b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{} \u6e32\u67d3\u5931\u8d25\uff0c\u6e32\u67d3\u8def\u5f84\uff1a{}", new Object[]{useDataModelBase.getComment(), operation.getName(), visitor.getClass().getName()});
                throw new LcdpException(var, String.format("\u6a21\u578b%s\u6e32\u67d3\u5931\u8d25\uff0c\u5f02\u5e38\uff1a%s", useDataModelBase.getComment(), var.getMessage()));
            }
            if (!backCtx.getUseDataModelBase().getIsPublishResource() || !ToolUtil.isNotEmpty((Object)pageInfoNode)) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
        useDataModelBase.customOption(backCtx);
    }

    public static void render(KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx, PublishCtx<KingBaseCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        KingBaseRender<KingBaseDataModelBase, KingBaseDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<KingBaseCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(KingBaseCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
        if (HussarUtils.isNotEmpty((Object)backCtx.getParams())) {
            backCtx.getParams().keySet().forEach(key -> {
                if (ToolUtil.isEmpty((Object)publishCtx.getParams())) {
                    publishCtx.addParams(new HashMap());
                }
                publishCtx.getParams().putIfAbsent(key, backCtx.getParam((String)key));
            });
        }
    }
}

