/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.masterslave.extension;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.function.visitor.masterslave.KingBaseMsFlagDeleteVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEMASTER_SLAVEextensionDelFlag")
public class KingBaseMsFlagDeleteExtensionVisitor
implements KingBaseOperationVisitor<KingBaseMsDataModel, KingBaseMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseMsFlagDeleteVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEMASTER_SLAVEextensionDelFlag";
    private static final String DELGETSTR = "::get";

    @Override
    public void visit(KingBaseBackCtx<KingBaseMsDataModel, KingBaseMsDataModelDTO> backCtx, KingBaseDataModelOperation operation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String currentModelId = backCtx.getUseDataModelBase().getId();
        KingBaseMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        KingBaseMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        KingBaseDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<KingBaseRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            logger.error("\u5b50\u8868\u5173\u8054\u5173\u7cfb\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a\u6216\u4e3b\u8868\u5bf9\u8c61\u4e3a\u7a7a");
            return;
        }
        KingBaseDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        for (KingBaseRelationshipDTO relationshipDTO : relationshipDtoList) {
            relationshipDTO.init();
        }
        StringBuilder relationStr = this.getDelStr(relationshipDtoList, masterDto);
        String url = baseDataModelDTO.getApiPrefix(new String[0]) + "/" + operation.getName();
        Map<String, Object> params = operation.getParams();
        List<KingBaseDataModelFieldDto> fields = baseDataModelDTO.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i).getId().equals(operation.getParams().get("mainId"))) {
                params.put("mainId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (fields.get(i).getId().equals(operation.getParams().get("pId"))) {
                params.put("pId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (!HussarUtils.isNotEmpty((Object)fields.get(i).getFill()) || !fields.get(i).getFill().equals("primary")) continue;
            params.put("mainName", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
        }
        params.put("masterTable", masterDto);
        params.put("table", baseDataModelDTO);
        params.put("masterSlaveTable", baseDataModelDTO);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        params.put("logicallyDelete", isLogicallyDelete);
        params.put("url", url);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            params.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(baseDataModelDTO.getComment() + "\u5220\u9664\u4e3b\u5b50");
            params.put("exegesis", operation.getExegesis());
        }
        logger.debug("\u751f\u6210serviceImpl\u6267\u884c\u5f00\u59cb");
        boolean delFlag = true;
        for (KingBaseRelationshipDTO kingbaseRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            KingBaseDataModelBaseDTO kingbaseDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(kingbaseRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, kingbaseDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, kingbaseDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, kingbaseDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        String implPath = "template/kingbase/masterslavebackcode/extension/flagdelete/service_impl.ftl";
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplCode(currentModelId, RenderUtil.renderTemplate((String)implPath, params));
        backCtx.addServiceImplImport(currentModelId, "org.springframework.beans.factory.annotation.Autowired");
        backCtx.addServiceImplImport(currentModelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Mapper"));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postForm", baseDataModelDTO.getApiPrefix(new String[0]) + "/" + operation.getName(), "\u5220\u9664");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    public StringBuilder getDelStr(List<KingBaseRelationshipDTO> relationshipDtoList, KingBaseDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        ArrayList<KingBaseRelationshipDTO> relationshipDTOS = new ArrayList<KingBaseRelationshipDTO>(relationshipDtoList);
        for (KingBaseRelationshipDTO relationtMap : relationshipDTOS) {
            if (!relationtMap.getSlaveTableDto().isExtension()) {
                relationshipDtoList.remove(relationtMap);
                continue;
            }
            List<KingBaseRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            KingBaseRelationshipFieldDTO kingbaseRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                Optional<KingBaseDataModelFieldDto> relationTag;
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(kingbaseRelationshipFieldDTO.getSlaveFieldCap()).append(",ids)");
                List<KingBaseDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    KingBaseDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(kingbaseRelationshipFieldDTO.getSlaveFieldCap()).append(",ids)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                Optional<KingBaseDataModelFieldDto> relationTag;
                KingBaseRelationshipFieldDTO kingbaseRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(kingbaseRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(kingbaseRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(kingbaseRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(KingBaseMsFlagDeleteExtensionVisitor.lowercase(masterDto.getEntityName())).append(".get").append(kingbaseRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(kingbaseRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(KingBaseMsFlagDeleteExtensionVisitor.lowercase(masterDto.getEntityName())).append(".get").append(kingbaseRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                List<KingBaseDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    KingBaseDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }
}

