/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.base;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEBASESerialNumber")
public class KingBaseSerialNumberVisitor
implements KingBaseOperationVisitor<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEBASESerialNumber";

    @Override
    public void visit(KingBaseBackCtx<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        KingBaseBaseDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        KingBaseBaseDataModelDTO kingbaseBaseDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Optional<KingBaseDataModelFieldDto> serialFieldOpt = kingbaseBaseDataModelDTO.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", kingbaseBaseDataModelDTO);
        KingBaseDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("returnValue", kingbaseBaseDataModelDTO.getEntityName());
        kingbaseBaseDataModelDTO.addServiceImplImport(kingbaseBaseDataModelDTO.getImportInfo().get("Entity"));
        kingbaseBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        kingbaseBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        kingbaseBaseDataModelDTO.addServiceImplImport("java.util.HashMap");
        kingbaseBaseDataModelDTO.addServiceImplImport("java.util.Map");
        kingbaseBaseDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        kingbaseBaseDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        kingbaseBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        kingbaseBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        kingbaseBaseDataModelDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        kingbaseBaseDataModelDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplInversion(useDataModelBase.getId(), "ISysCodeRuleService");
        String implPath = "template/kingbase/backcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/kingbase/backcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSONObject.toJSONString((Object)useDataModelBase)), useDataModelBase.getComment(), useDataModelBase.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

