/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.task.masterslavetask;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseQueryDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.function.visitor.constant.KingBaseConstUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.visitor.masterslave.util.KingBaseMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseBackRenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASETASK_MASTER_SLAVEDataImport")
public class KingBaseMsTaskDataImportVisitor
implements KingBaseOperationVisitor<KingBaseTaskMsDataModel, KingBaseTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseMsTaskDataImportVisitor.class);
    public static final String OPERATION_NAME = "KINGBASETASK_MASTER_SLAVEDataImport";

    @Override
    public void visit(KingBaseBackCtx<KingBaseTaskMsDataModel, KingBaseTaskMsDataModelDTO> taskBackCtx, KingBaseDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        KingBaseFlowMsDataModelDTO flowMsDataModelDTO = (KingBaseFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        KingBaseFlowMsDataModel flowMsDataModel = (KingBaseFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx = new KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(flowMsDataModel);
        HashMap<String, KingBaseFlowMsDataModelDTO> map = new HashMap<String, KingBaseFlowMsDataModelDTO>();
        map.put(modelId, flowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, flowMsDataModelDTO);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (KingBaseDataModelBase kingBaseDataModelBase : flowMsDataModel.getSlaveTables()) {
            KingBaseDataModelBaseDTO kingbaseDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(kingBaseDataModelBase.getId());
            String slaveModelName = kingBaseDataModelBase.getName();
            for (KingBaseDataModelFieldDto kingBaseDataModelFieldDto : kingbaseDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(kingBaseDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, kingBaseDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        HashMap<String, Boolean> slaveTablePlusSave = new HashMap<String, Boolean>();
        for (KingBaseRelationshipDTO relationshipDTO : flowMsDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        for (KingBaseDataModelBase modelBase : flowMsDataModel.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((KingBaseBaseDataModel)modelBase).getLogicallyDelete());
            KingBaseDataModelBaseDTO kingbaseDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, KingBaseMasterSlaveUtil.getCapitalName(slaveModelName));
            for (KingBaseDataModelField kingBaseDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(kingBaseDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, kingBaseDataModelField.getName());
            }
            for (KingBaseDataModelFieldDto kingBaseDataModelFieldDto : kingbaseDataModelBaseDTO.getFields()) {
                if ("primary".equals(kingBaseDataModelFieldDto.getFill())) {
                    primaryKeys.put(slaveModelName, kingBaseDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(kingBaseDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, kingBaseDataModelFieldDto.getCapitalName());
            }
        }
        this.addFormPlusSaveDto(flowMsDataModel, flowMsDataModelDTO, backCtx, slaveTablePlusSave);
        controllerParams.put("table", flowMsDataModelDTO);
        controllerParams.put("returnValue", flowMsDataModelDTO.getEntityName());
        KingBaseDataModelBaseDTO kingBaseDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(flowMsDataModel.getMasterTable().getId());
        controllerParams.put("masterTable", kingBaseDataModelBaseDTO);
        String controllerPath = "template/kingbase/taskbackcode/masterslavetaskbackcode/templateImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, flowMsDataModelDTO.getServiceName());
        String servicePath = "template/kingbase/taskbackcode/masterslavetaskbackcode/templateImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        this.masterSlaveCode(backCtx, controllerParams);
        KingBaseDataModelFieldDto keyField = flowMsDataModelDTO.getKeyField();
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        String string = "template/kingbase/taskbackcode/masterslavetaskbackcode/templateImport/service_impl.ftl";
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        controllerParams.put("primaryKeys", primaryKeys);
        controllerParams.put("foreignKeys", foreignKeys);
        controllerParams.put("slaveTable", KingBaseMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        controllerParams.put("isLogicallyDelete", isLogicallyDelete);
        controllerParams.put("logicallyDelField", logicallyDelField);
        controllerParams.put("capitalNameList", capitalNameList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        this.renderImport(backCtx, modelId, flowMsDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", flowMsDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, KingBaseBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, String modelId, KingBaseFlowMsDataModelDTO flowMsDataModelDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.template.print.utils.VerifyExcelUtil");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.model.SysExcelTask");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.constants.TaskConstants");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.service.ISysExcelTaskService");
        backCtx.addServiceImplImport(modelId, "java.time.LocalDateTime");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplInversion(modelId, "ISysExcelTaskService");
        backCtx.addServiceImplInversion(modelId, "HussarThreadPoolConfiguration");
        backCtx.addServiceImplImport(modelId, "java.io.IOException");
        backCtx.addServiceImplImport(modelId, "java.io.InputStream");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.SecurityUser");
        backCtx.addServiceImplImport(modelId, "java.util.concurrent.Executor");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration");
    }

    private Map<String, Object> initParams(KingBaseDataModelOperation dataModelOperation, KingBaseMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6a21\u677f\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void masterSlaveCode(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        KingBaseFlowMsDataModel flowMsDataModel = backCtx.getUseDataModelBase();
        String modelId = flowMsDataModel.getId();
        KingBaseFlowMsDataModelDTO flowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<KingBaseRelationshipDTO> relationshipDtoList = flowMsDataModelDTO.getRelationshipDtoList();
        KingBaseDataModelBase masterTable = flowMsDataModel.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, KingBaseDataModelBaseDTO> dataModelDtoMap = flowMsDataModelDTO.getDataModelDtoMap();
        KingBaseDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, flowMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)flowMsDataModel) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (KingBaseRelationshipDTO kingbaseRelationshipDTO : relationshipDtoList) {
                List<KingBaseRelationshipFieldDTO> kingbaseRelationshipFieldDTOS;
                String slaveTableId = kingbaseRelationshipDTO.getSlaveTableId();
                String relateModelType = kingbaseRelationshipDTO.getRelateModelType();
                KingBaseDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, flowMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    kingbaseRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(kingbaseRelationshipFieldDTOS = kingbaseRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, KingBaseDataModelBaseDTO dataModelBaseDTO, KingBaseFlowMsDataModelDTO msDataModelDTO, boolean isMs, KingBaseDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (KingBaseDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", KingBaseConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", KingBaseConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", KingBaseConstUtil.TRUE);
                    break;
                }
                case "primary": {
                    insertFill = true;
                    params.put("insertFill", KingBaseConstUtil.TRUE);
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.support.engine.core.util.EngineUtil");
                    params.put("primaryFill", KingBaseConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/kingbase/masterslavebackcode/templateImport/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private void addFormPlusSaveDto(KingBaseFlowMsDataModel flowMsDataModel, KingBaseFlowMsDataModelDTO flowMsDataModelDTO, KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        KingBaseQueryDTO queryDTO = new KingBaseQueryDTO();
        String modelId = flowMsDataModel.getId();
        String masterId = flowMsDataModel.getMasterTable().getId();
        queryDTO.setFtlPath("template/kingbase/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", flowMsDataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", KingBaseMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", flowMsDataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(flowMsDataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(flowMsDataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(flowMsDataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(flowMsDataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = flowMsDataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        flowMsDataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }
}

