/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseBackRenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEFLOWEditTableSave")
public class KingBaseFlowEditTableSaveVisitor
implements KingBaseOperationVisitor<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseFlowEditTableSaveVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEFLOWEditTableSave";

    @Override
    public void visit(KingBaseBackCtx<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        KingBaseFlowDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        KingBaseFlowDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        KingBaseDataModelFieldDto keyField = dataModelBaseDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("primaryFieldType", keyField.getColumnType().getType());
        this.renderFillCode(backCtx, dataModelBaseDTO, controllerParams);
        this.renderFlagDeleteCode(dataModelBaseDTO, controllerParams);
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        String controllerPath = "template/kingbase/backcode/editTableSave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/kingbase/backcode/editTableSave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        if (useDataModelBase.getLogicallyDelete()) {
            controllerParams.put("logicallyDelete", true);
            String logicallyFieldName = useDataModelBase.getDeleteFlag().getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("logicallyFlag", String.valueOf(chars));
        }
        String serviceImplPath = "template/kingbase/backcode/editTableSave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u53ef\u7f16\u8f91\u8868\u683c\u5bfc\u5165");
        backCtx.addApi(modelId, KingBaseBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(KingBaseBackCtx<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> backCtx, String modelId, KingBaseFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
        backCtx.addServiceImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
    }

    private Map<String, Object> initParams(KingBaseDataModelOperation dataModelOperation, KingBaseFlowDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u53ef\u7f16\u8f91\u8868\u683c\u6570\u636e\u66f4\u65b0");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void renderFillCode(KingBaseBackCtx<KingBaseFlowDataModel, KingBaseFlowDataModelDTO> backCtx, KingBaseFlowDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) throws LcdpException {
        boolean insertFill = false;
        boolean updateFill = false;
        for (KingBaseDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    controllerParams.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)dataModelBaseDTO.getId()), dataModelBaseDTO.getComment(), dataModelBaseDTO.getSourceDataModelName(), field.getName(), controllerParams, false, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        dataModelBaseDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    controllerParams.put("insertFill", true);
                    break;
                }
                case "updateUser": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        dataModelBaseDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    controllerParams.put("insertFill", true);
                    updateFill = true;
                    controllerParams.put("updateFill", true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return;
        }
        String fillPath = "template/kingbase/backcode/addorupdate/fill.ftl";
        String fillCode = RenderUtil.renderTemplate((String)fillPath, controllerParams);
        controllerParams.put("fillCode", fillCode);
    }

    private void renderFlagDeleteCode(KingBaseFlowDataModelDTO flowDataModelDTO, Map<String, Object> controllerParams) throws LcdpException {
        for (KingBaseDataModelFieldDto field : flowDataModelDTO.getFields()) {
            if (field.getFill() == null || !field.getFill().equals("delDefFlag")) continue;
            controllerParams.put("delFlag", true);
        }
        String fillPath = "template/kingbase/backcode/editTableSave/flagDelete.ftl";
        String flagDeleteCode = RenderUtil.renderTemplate((String)fillPath, controllerParams);
        controllerParams.put("flagDeleteCode", flagDeleteCode);
    }
}

