/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.base;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseBackRenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEBASEFormSave")
public class KingBaseFormSaveVisitor
implements KingBaseOperationVisitor<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseFormSaveVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEBASEFormSave";

    @Override
    public void visit(KingBaseBackCtx<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        KingBaseBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        KingBaseDataModelFieldDto keyField = dataModelBaseDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        controllerParams.put("primaryField", keyField.getCapitalName());
        this.renderFillCode(backCtx, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/kingbase/backcode/addorupdate/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/kingbase/backcode/addorupdate/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/kingbase/backcode/addorupdate/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, KingBaseBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderFillCode(KingBaseBackCtx<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> backCtx, KingBaseBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) throws LcdpException {
        boolean insertFill = false;
        boolean updateFill = false;
        for (KingBaseDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    controllerParams.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)dataModelBaseDTO.getId()), dataModelBaseDTO.getComment(), dataModelBaseDTO.getSourceDataModelName(), field.getName(), controllerParams, false, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        dataModelBaseDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    controllerParams.put("insertFill", true);
                    break;
                }
                case "updateUser": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        dataModelBaseDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    controllerParams.put("insertFill", true);
                    updateFill = true;
                    controllerParams.put("updateFill", true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return;
        }
        String fillPath = "template/kingbase/backcode/addorupdate/fill.ftl";
        String fillCode = RenderUtil.renderTemplate((String)fillPath, controllerParams);
        controllerParams.put("fillCode", fillCode);
    }

    private void renderImport(KingBaseBackCtx<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> backCtx, String modelId, KingBaseBaseDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
    }

    private Map<String, Object> initParams(KingBaseDataModelOperation dataModelOperation, KingBaseBaseDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

