/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.element.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseEnclosure;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseRender;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseDataModelUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KingBaseTaskMsDataModel
extends KingBaseMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(KingBaseTaskMsDataModel.class);
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    public static final String TASK_KEY = "task";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private KingBaseBaseDataModel task;
    private List<KingBaseDataModelField> flowFields;

    public List<KingBaseDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<KingBaseDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"KINGBASE.TASK_MASTER_SLAVE", KingBaseTaskMsDataModel.class);
    }

    public KingBaseBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(KingBaseBaseDataModel task) {
        this.task = task;
    }

    @Override
    public KingBaseTaskMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        KingBaseTaskMsDataModel kingbaseTaskMsDataModel;
        try {
            ArrayList<KingBaseDataModelField> fieldList = new ArrayList<KingBaseDataModelField>();
            kingbaseTaskMsDataModel = (KingBaseTaskMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), KingBaseTaskMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                KingBaseDataModelBase master = KingBaseDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(kingbaseTaskMsDataModel.getName() + "Master");
                kingbaseTaskMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<KingBaseDataModelBase> slaveTables = new ArrayList<KingBaseDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    KingBaseDataModelBase slaveTable = KingBaseDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (KingBaseRelationshipBase relationship : kingbaseTaskMsDataModel.getRelationships()) {
                    if (relationship.getMasterTableId().equals(kingbaseTaskMsDataModel.task.getId())) continue;
                    KingBaseDataModelBase dataModelBase = slaveTables.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)relationship.getSlaveTableId())).findFirst().orElseGet(KingBaseBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    KingBaseDataModelField kingbaseDataModelField = new KingBaseDataModelField();
                    kingbaseDataModelField.setId(UUID.randomUUID().toString());
                    kingbaseDataModelField.setName(dataModelBase.getName());
                    kingbaseDataModelField.setComment(dataModelBase.getComment());
                    kingbaseDataModelField.setSourceDataModelId(dataModelBase.getId());
                    kingbaseDataModelField.setDataType("array");
                    fieldList.add(kingbaseDataModelField);
                }
                kingbaseTaskMsDataModel.setSlaveTables(slaveTables);
            }
            kingbaseTaskMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return kingbaseTaskMsDataModel;
    }

    @Override
    public KingBaseEnclosure<KingBaseDataModelBase> enclosure() throws LcdpException {
        return KingBaseModelBeanUtil.getEnclosureBean("KINGBASE", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public KingBaseRender<KingBaseDataModelBase, KingBaseDataModelBaseDTO> render() throws LcdpException {
        return KingBaseModelBeanUtil.getRenderBean("KINGBASE", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<KingBaseDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<KingBaseDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<KingBaseDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<KingBaseDataModelField>> contrastVOS = this.task.modelContrastTable((FieldsContrastParam<KingBaseDataModelField>)fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable((FieldsContrastParam<KingBaseDataModelField>)fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.addAll(super.checkTableContrast(modelId).getDetails());
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.getMasterTable().getId(), "T2");
        List<KingBaseRelationshipBase> relationships = super.getRelationships();
        if (ToolUtil.isNotEmpty(relationships) && !relationships.isEmpty()) {
            for (int i = 0; i < relationships.size(); ++i) {
                KingBaseRelationshipBase relationship = relationships.get(i);
                if (relationship.getSlaveTableId().equals(super.getId())) continue;
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(KingBaseBackCtx<KingBaseDataModelBase, KingBaseDataModelBaseDTO> backCtx) throws LcdpException {
        KingBaseModelBeanUtil.getCustomOperationBean("KINGBASE", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }
}

