/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseEnclosure;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.translate.KingBaseTranslate;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBasePublicEnclosure;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEFLOWENCLOSURE")
public class KingBaseFlowEnclosure
implements KingBaseEnclosure<KingBaseFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseFlowEnclosure.class);
    public static final String ENCLOSURE = "KINGBASEFLOWENCLOSURE";

    @Override
    public KingBaseDataModelBaseDTO enclosure(KingBaseFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<KingBaseDataModelField> dataModelFieldBases;
        KingBaseFlowDataModelDTO dataModelBaseDTO = new KingBaseFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        KingBasePublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new KingBaseFlowDataModelDTO();
        }
        ArrayList<KingBaseDataModelFieldDto> tableFields = new ArrayList<KingBaseDataModelFieldDto>();
        for (KingBaseDataModelField dataModelFieldBase : dataModelFieldBases) {
            KingBaseDataModelFieldDto tableField = new KingBaseDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        List<KingBaseTranslate> translates = dataModelBase.getTranslate();
        if (ToolUtil.isNotEmpty(translates)) {
            List rightFields = ModelProvideAdapter.adaptor((String)dataModelBase.getId()).getFields(dataModelBase.getId());
            List<Map<String, Object>> translateAnnotations = KingBaseTranslateUtil.translate(translates, rightFields);
            if (ToolUtil.isNotEmpty(translateAnnotations)) {
                List<KingBaseDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                block1: for (Map map : translateAnnotations) {
                    if (!ToolUtil.isNotEmpty((Object)map) || !ToolUtil.isNotEmpty(map.get("fieldId"))) continue;
                    for (KingBaseDataModelFieldDto field : fields) {
                        if (!field.getId().equals(map.get("fieldId").toString())) continue;
                        field.setFieldAnnotation(map.get("fieldAnnotation").toString());
                        continue block1;
                    }
                }
                dataModelBaseDTO.setFields(fields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<KingBaseDataModelFieldDto> translateShowFields = KingBaseTranslateUtil.getTranslateShowFields(translates);
            for (KingBaseDataModelFieldDto kingBaseDataModelFieldDto : translateShowFields) {
                if (null == kingBaseDataModelFieldDto.getColumnType() || null == kingBaseDataModelFieldDto.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(kingBaseDataModelFieldDto.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
        return dataModelBaseDTO;
    }
}

