package ${package!};

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import ${implementServiceNameImportInfo!};
import ${ProcessInfoDtoImportInfo!};
import ${DeletedProcessInfoDtoImportInfo!};
import ${ProcessNodeInfoDtoImportInfo!};
import ${UpdateTaskUserDtoImportInfo!};
import ${WorkflowUserDtoImportInfo!};
import ${CompleteTaskInfoDtoImportInfo!};
import ${TaskInfoDtoImportInfo!};
import ${DeletedTaskInfoDtoImportInfo!};

import ${taskEntityImportInfo!};
import ${taskServiceImportInfo!};
import ${businessServiceImportInfo!};
import ${businessEntityImportInfo!};
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
<#list imports! as import>
    import ${import};
</#list>

/**
* 流程数据回填服务实现类
*/
@Component("${identity}")
<#if dataSourceName?? && dataSourceName != "">
@HussarDs("${dataSourceName}")
</#if>
public class ${className} implements ${implementServiceName}{

    @Autowired
    private ${taskServiceName} ${taskServiceName?uncap_first};

    @Autowired
    private ${businessServiceName} ${businessServiceName?uncap_first};

    /* @begin Autowired #自定义注入 */
    /* @end Autowired */

    /**
    * 流程信息修改
    * @param processInfoDto 流程信息
    * @return 是否修改成功
    */
    @Override
    public boolean changeProcessInfo(ProcessInfoDto processInfoDto) {
        <#if businessColumn??>
            UpdateWrapper<${businessEntity}> updateWrapper = Wrappers.update();
            updateWrapper.eq("${businessColumn.primary!}", ${primaryType}.valueOf(processInfoDto.getBusinessId()));
            <#if businessColumn.processkey?? && businessColumn.processkey != ''>
            updateWrapper.set("${businessColumn.processkey!}", processInfoDto.getProcessKey());
            </#if>
            <#if businessColumn.processState?? && businessColumn.processState != ''>
            updateWrapper.set("${businessColumn.processState!}", processInfoDto.getProcessState());
            </#if>
            <#if businessColumn.processInstId?? && businessColumn.processInstId != ''>
            updateWrapper.set("${businessColumn.processInstId!}", processInfoDto.getProcessInstanceId());
            </#if>
            <#if businessColumn.startTime?? && businessColumn.startTime != ''>
             updateWrapper.set("${businessColumn.startTime!}", processInfoDto.getStartTime());
            </#if>
            <#if businessColumn.finishTime?? && businessColumn.finishTime != ''>
            updateWrapper.set("${businessColumn.finishTime!}", processInfoDto.getFinishTime());
            </#if>
            /* @begin changeProcessInfo #自定义代码 */
            /* @end changeProcessInfo */
            return ${businessServiceName?uncap_first}.update(updateWrapper);
        <#else>
            return true;
        </#if>

    }

    /**
    * 删除流程
    * @param deletedProcessInfoDtos
    * @return
    */
    @Override
    public boolean deleteProcess(List<DeletedProcessInfoDto> deletedProcessInfoDtos) {
        <#if businessColumn?? && ((businessColumn.processState?? && businessColumn.processState != '')
                || (businessColumn.finishTime?? && businessColumn.finishTime != ''))>
        List<${primaryType}> ids = new ArrayList<>();
        if (deletedProcessInfoDtos != null && deletedProcessInfoDtos.size() > 0) {
            UpdateWrapper<${businessEntity}> updateWrapper = Wrappers.update();
            for (DeletedProcessInfoDto deletedProcessInfoDto : deletedProcessInfoDtos) {
                ids.add(${primaryType}.valueOf(deletedProcessInfoDto.getBusinessId()));
            }
            updateWrapper.in("${businessColumn.primary!}", ids);
            DeletedProcessInfoDto deletedProcessInfo = deletedProcessInfoDtos.get(0);
            <#if businessColumn.processState?? && businessColumn.processState != ''>
            // 修改流程状态
            updateWrapper.set("${businessColumn.processState!}", deletedProcessInfo.getProcessState());
            </#if>
            <#if businessColumn.finishTime?? && businessColumn.finishTime != ''>
            // 修改结束时间
            updateWrapper.set("${businessColumn.finishTime!}", deletedProcessInfo.getFinishTime());
            </#if>
            /* @begin deleteProcess #自定义代码 */
            /* @end deleteProcess */
            ${businessServiceName?uncap_first}.update(updateWrapper);
            return true;
        }
        return false;
        <#else>
        return true;
        </#if>
    }

    /**
    * 修改流程节点
    * @param processNodeInfoDto
    * @return
    */
    @Override
    public boolean changeProcessNode(ProcessNodeInfoDto processNodeInfoDto) {
         <#if businessColumn?? && ((businessColumn.primary?? && businessColumn.primary != '')
                && (businessColumn.processNode?? && businessColumn.processNode != ''))>
         UpdateWrapper<${businessEntity}> updateWrapper = Wrappers.update();
             updateWrapper.eq("${businessColumn.primary!}", ${primaryType}.valueOf(processNodeInfoDto.getBusinessId()));
         updateWrapper.set("${businessColumn.processNode!}", analyzeProcessNode(processNodeInfoDto.getProcessNodeList()));
         /* @begin changeProcessNode #自定义代码 */
         /* @end changeProcessNode */
         ${businessServiceName?uncap_first}.update(updateWrapper);
         return true;
        <#else>
         return true;
        </#if>
    }

    <#if businessColumn?? && ((businessColumn.primary?? && businessColumn.primary != '')
            || (businessColumn.processNode?? && businessColumn.processNode != ''))>
    private String analyzeProcessNode(List<ProcessNode> nodeList) {
        String processNode = "";
        if (nodeList != null && nodeList.size() > 0) {
            for (ProcessNode node : nodeList) {
                // 获取节点名称
                String nodeName = node.getTaskDefinitionName();
                if (node.getChildrenList() != null && node.getChildrenList().size() > 0) {
                    nodeName += "(";
                    for (ProcessNode childNode : node.getChildrenList()) {
                        nodeName += childNode.getTaskDefinitionName() + "、";
                    }
                    nodeName = nodeName.substring(0, nodeName.length() - 1) + ")";
                }
                if (processNode.length() == 0) {
                    processNode += nodeName;
                } else {
                    processNode += "-" + nodeName;
                }
            }
        }
        return processNode;
    }
    </#if>

    /**
    * 任务新增
    * @param taskInfoDto 任务表dto
    * @return
    */
    @Override
    public Integer addTaskInfo(TaskInfoDto taskInfoDto){
        // 判断有多少参与者
        if (taskInfoDto.getUsers() == null || taskInfoDto.getUsers().size() == 0) {
            ${taskEntity} ${taskEntity?uncap_first} = this.taskInfoDtoToTaskEntity(taskInfoDto);
            return ${taskServiceName?uncap_first}.save(${taskEntity?uncap_first}) ? 1 : 0;
        }
        List<${taskEntity}> ${taskEntity?uncap_first}List = new ArrayList<>();
            for (WorkflowUserDto user : taskInfoDto.getUsers()) {
                ${taskEntity} ${taskEntity?uncap_first} = this.taskInfoDtoToTaskEntity(taskInfoDto);
                ${taskEntity?uncap_first}.setAssignee(user.getUserId());
                ${taskEntity?uncap_first}List.add(${taskEntity?uncap_first});
            }
        /* @begin addTaskInfo #自定义代码 */
        /* @end addTaskInfo */
        return ${taskServiceName?uncap_first}.saveBatch(${taskEntity?uncap_first}List, taskInfoDto.getUsers().size()) ? taskInfoDto.getUsers().size(): 0;
    }

    private ${taskEntity} taskInfoDtoToTaskEntity(TaskInfoDto taskInfoDto) {
        ${taskEntity} ${taskEntity?uncap_first} = new ${taskEntity}();
        ${taskEntity?uncap_first}.setBusinessId(${primaryType}.valueOf(taskInfoDto.getBusinessId()));
        // 两边类型不一样 任务表这边是 long；dto里是string
        ${taskEntity?uncap_first}.setTaskId(taskInfoDto.getTaskId());
        ${taskEntity?uncap_first}.setTaskDefKey(taskInfoDto.getTaskDefinitionKey());
        ${taskEntity?uncap_first}.setTaskDefName(taskInfoDto.getTaskDefinitionName());
        ${taskEntity?uncap_first}.setFormKey(taskInfoDto.getFormKey());
        ${taskEntity?uncap_first}.setFormDetailKey(taskInfoDto.getFormDetailKey());
        // 两边类型不一致 需要转换下
        ${taskEntity?uncap_first}.setTaskCreateTime(taskInfoDto.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        ${taskEntity?uncap_first}.setTaskState(taskInfoDto.getTaskState());
        ${taskEntity?uncap_first}.setTaskType(taskInfoDto.getTaskType());
        return ${taskEntity?uncap_first};
    }

    @Override
    public boolean completeTask(List<CompleteTaskInfoDto> completeTaskInfoDtos) {
        boolean flag = true;
        for (CompleteTaskInfoDto completeTaskInfoDto : completeTaskInfoDtos) {
            if (completeTaskInfoDto.getTaskId() != null && completeTaskInfoDto.getTaskId().length() > 0) {
                // 获取库中任务表信息 一条
                QueryWrapper<${taskEntity}> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("${taskTaskId!}", completeTaskInfoDto.getTaskId());
                queryWrapper.last("limit 1");
                ${taskEntity} ${taskEntity?uncap_first} = ${taskServiceName?uncap_first}.getOne(queryWrapper);
                // 删除 库中的任务信息
                QueryWrapper<${taskEntity}> removeWrapper = new QueryWrapper<>();
                removeWrapper.eq("${taskTaskId!}", completeTaskInfoDto.getTaskId());
                ${taskServiceName?uncap_first}.remove(removeWrapper);
                // 任务结束时间
                ${taskEntity?uncap_first}.setEndTime(completeTaskInfoDto.getEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                // 任务类型
                ${taskEntity?uncap_first}.setTaskType(completeTaskInfoDto.getTaskType());
                //任务状态
                ${taskEntity?uncap_first}.setTaskState(completeTaskInfoDto.getTaskState());
                // 任务办理人
                ${taskEntity?uncap_first}.setAssignee(completeTaskInfoDto.getAssignee());
                /* @begin completeTask #自定义代码 */
                /* @end completeTask */
                boolean saveFlag = ${taskServiceName?uncap_first}.save(${taskEntity?uncap_first});
                if (!saveFlag) {
                    flag = saveFlag;
                }
            }
        }
        return flag;
    }

    @Override
    public Integer updateTaskUser(List<UpdateTaskUserDto> updateTaskUserDtos) {
        Integer article = 0;
        for (UpdateTaskUserDto updateTaskUserDto : updateTaskUserDtos) {
            if (updateTaskUserDto.getTaskId() != null && updateTaskUserDto.getTaskId().length() > 0) {
                QueryWrapper<${taskEntity}> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("${taskTaskId!}", updateTaskUserDto.getTaskId());
                queryWrapper.last("limit 1");
                /* @begin updateTaskUser1 #自定义代码 */
                /* @end updateTaskUser1 */
                ${taskEntity} ${taskEntity?uncap_first} = ${taskServiceName?uncap_first}.getOne(queryWrapper);
                ${taskEntity?uncap_first}.setTaskInfoId(null);
                // 删除 库中的任务信息
                QueryWrapper<${taskEntity}> removeWrapper = new QueryWrapper<>();
                removeWrapper.eq("${taskTaskId!}", updateTaskUserDto.getTaskId());
                /* @begin updateTaskUser2 #自定义代码 */
                /* @end updateTaskUser2 */
                ${taskServiceName?uncap_first}.remove(removeWrapper);
                // 判断有多少参与者
                if (updateTaskUserDto.getUsers() == null || updateTaskUserDto.getUsers().size() == 0) {
                    ${taskEntity?uncap_first}.setAssignee(null);
                    /* @begin updateTaskUser3 #自定义代码 */
                    /* @end updateTaskUser3 */
                    boolean saveFlag = ${taskServiceName?uncap_first}.save(${taskEntity?uncap_first});
                    if (saveFlag) {
                        article++;
                    }
                } else {
                    List<${taskEntity}> ${taskEntity?uncap_first}List = new ArrayList<>();
                    for (WorkflowUserDto user : updateTaskUserDto.getUsers()) {
                        ${taskEntity} cloneTaskModelEntity = HussarUtils.clone(${taskEntity?uncap_first});
                        cloneTaskModelEntity.setAssignee(user.getUserId());
                        ${taskEntity?uncap_first}List.add(cloneTaskModelEntity);
                    }
                    /* @begin updateTaskUser4 #自定义代码 */
                    /* @end updateTaskUser4 */
                    boolean saveBatchFlag = ${taskServiceName?uncap_first}.saveBatch(${taskEntity?uncap_first}List, updateTaskUserDto.getUsers().size());
                    if (saveBatchFlag) {
                        article += updateTaskUserDto.getUsers().size();
                    }
                }
            }
        }
        return article;
    }

    /**
    * 任务删除
    * @param deletedTaskInfoDtos 任务删除dto的list
    * @return 是否删除成功
    */
    @Override
    public boolean deleteTaskInfo(List<DeletedTaskInfoDto> deletedTaskInfoDtos) {
        List<String> taskIdList = new ArrayList<>();
        List<${primaryType}> businessIdList = new ArrayList<>();
        for (DeletedTaskInfoDto deletedTaskInfoDto : deletedTaskInfoDtos) {
            if (deletedTaskInfoDto.getTaskIdList() != null && deletedTaskInfoDto.getTaskIdList().size() > 0) {
                taskIdList.addAll(deletedTaskInfoDto.getTaskIdList());
            } else {
                for (String businessId : deletedTaskInfoDto.getBusinessIdList()) {
                    businessIdList.add(${primaryType}.valueOf(businessId));
                }
            }
        }
        if (taskIdList.size() > 0) {
            QueryWrapper<${taskEntity}> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("${taskTaskId!}", taskIdList);
            /* @begin deleteTaskInfo1 #自定义代码 */
            /* @end deleteTaskInfo1 */
            return ${taskServiceName?uncap_first}.remove(queryWrapper);
        } else if (businessIdList.size() > 0) {
            QueryWrapper<${taskEntity}> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("${taskForeign!}", businessIdList);
            /* @begin deleteTaskInfo2 #自定义代码 */
            /* @end deleteTaskInfo2 */
            return ${taskServiceName?uncap_first}.remove(queryWrapper);
        }
        return false;
   }

    /* @begin method #自定义方法 */
    /* @end method */

}
