/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.view;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.view.KingBaseViewDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.view.KingBaseViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseQueryDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.sortcondition.KingBaseSortCondition;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.sortcondition.KingBaseSortConditionField;
import com.jxdinfo.hussar.formdesign.kingbase.function.render.KingBaseViewRender;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEVIEWConditionFilter")
public class KingBaseViewConditionFilterVisitor
implements KingBaseOperationVisitor<KingBaseViewDataModel, KingBaseViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseViewConditionFilterVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEVIEWConditionFilter";

    @Override
    public void visit(KingBaseBackCtx<KingBaseViewDataModel, KingBaseViewDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation) throws LcdpException {
        boolean isPagination;
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        KingBaseViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelViewDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelViewDTO);
        controllerParams.put("returnValue", dataModelViewDTO.getEntityName());
        controllerParams.put("url", url);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelViewDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelViewDTO.getComment() + "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        this.renderSort(dataModelOperation, controllerParams, backCtx.getUseDataModelBase());
        isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderFilter(backCtx, dataModelOperation, modelId, dataModelViewDTO, controllerParams);
        this.renderPageVo(backCtx, modelId, dataModelViewDTO, controllerParams);
        String controllerPath = "template/kingbase/backcode/conditionFilter/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelViewDTO.getServiceName());
        String servicePath = "template/kingbase/backcode/conditionFilter/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/kingbase/backcode/conditionFilter/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelViewDTO, isSortOverall, isPagination);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", url, "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2");
        backCtx.addApi(modelId, KingBaseViewRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(KingBaseBackCtx<KingBaseViewDataModel, KingBaseViewDataModelDTO> backCtx, String modelId, KingBaseViewDataModelDTO dataModelBaseDTO, boolean isSortOverall, boolean isPagination) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
    }

    private boolean renderFilter(KingBaseBackCtx<KingBaseViewDataModel, KingBaseViewDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation, String modelId, KingBaseViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("showFilter"));
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        controllerParams.put("showFilter", true);
        KingBaseQueryDTO queryDTO = KingBaseDataModelUtil.getFilterDto(dataModelViewDTO);
        dataModelViewDTO.addQueryDto(queryDTO);
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private void renderSort(KingBaseDataModelOperation dataModelOperation, Map<String, Object> templateParams, KingBaseViewDataModel useDataModelBase) throws LcdpException {
        KingBaseSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(KingBaseSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<KingBaseSortConditionField> sortConditionFields = sortCondition.getFields();
            for (KingBaseSortConditionField sortConditionField : sortConditionFields) {
                sortConditionField.replaceFieldName();
            }
            templateParams.put("sortConditionObj", sortCondition);
            templateParams.put("isSortCondition", true);
        }
    }

    private void renderPageVo(KingBaseBackCtx<KingBaseViewDataModel, KingBaseViewDataModelDTO> backCtx, String modelId, KingBaseViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams) {
        KingBaseDataModelUtil.addQueryPageViewVo(dataModelViewDTO);
        String voEntityName = dataModelViewDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelViewDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

