/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SqlReturnUtil {
    protected static final int DEF_SB_SIZE = 128;

    public static String renderReturn(KingBaseMsDataModel dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<KingBaseDataModelField> dataModelFieldBases = dataModel.getFields();
        for (KingBaseDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturnNew(KingBaseDataModelBase dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<KingBaseDataModelField> dataModelFieldBases = dataModel.getFields();
        for (KingBaseDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId)) || "task".equals(aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturn(List<KingBaseDataModelField> dataModelFieldBases, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        for (KingBaseDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturn(KingBaseTaskDataModel dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<KingBaseDataModelField> dataModelFieldBases = dataModel.getFields();
        for (KingBaseDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static void renderAlias(KingBaseMsDataModel dataModel, Map<String, String> aliasMap, KingBaseDataModelBaseDTO dataModelBaseDTO) {
        String template = "${alias}.${attrReal}";
        List<KingBaseDataModelField> dataModelFieldBases = dataModel.getFields();
        List<KingBaseDataModelFieldDto> dataModelFieldDtos = dataModelBaseDTO.getFields();
        for (KingBaseDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            for (KingBaseDataModelFieldDto dataModelFieldDto : dataModelFieldDtos) {
                if (dataModelFieldDto.getName() == null || !dataModelFieldDto.getId().equals(dataModelFieldBase.getId())) continue;
                dataModelFieldDto.setAliasName(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField));
            }
        }
    }

    public static void renderAlias(KingBaseTaskDataModel dataModel, Map<String, String> aliasMap, KingBaseTaskDataModelDTO dataModelBaseDTO) {
        String template = "${alias}.${attrReal}";
        List<KingBaseDataModelField> dataModelFieldBases = dataModel.getFields();
        List<KingBaseDataModelFieldDto> dataModelFieldDtos = dataModelBaseDTO.getFields();
        for (KingBaseDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            for (KingBaseDataModelFieldDto dataModelFieldDto : dataModelFieldDtos) {
                if (dataModelFieldDto.getName() == null || !dataModelFieldDto.getId().equals(dataModelFieldBase.getId())) continue;
                dataModelFieldDto.setAliasName(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField));
            }
        }
    }

    public static String renderRelation(KingBaseMsDataModel dataModelBase, Map<String, KingBaseDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<KingBaseRelationshipBase> relationships = dataModelBase.getRelationships();
        KingBaseDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = masterTable.getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (KingBaseRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                KingBaseDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), dataModelBase, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderRelation(KingBaseTaskMsDataModel dataModelBase, Map<String, KingBaseDataModelBase> dataModelBaseMap) {
        String condition;
        String alias;
        String modelRealName;
        KingBaseDataModelBase slaveTable;
        KingBaseDataModelBase masterTable;
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<KingBaseRelationshipBase> relationships = dataModelBase.getRelationships();
        KingBaseBaseDataModel taskTable = dataModelBase.getTask();
        String taskId = taskTable.getId();
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            String mainModel = ((KingBaseDataModelBase)taskTable).getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(taskId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (KingBaseRelationshipBase relationship : relationships) {
                if (!relationship.getMasterTableId().equals(dataModelBase.getTask().getId())) continue;
                masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                slaveTable = dataModelBaseMap.get(dataModelBase.getMasterTable().getId());
                modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                alias = modelAlias.get(slaveTable.getId());
                condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(taskId), slaveTable);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) break;
                relationResult.append("ON\n").append(condition);
                break;
            }
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (KingBaseRelationshipBase relationship : relationships) {
                if (relationship.getMasterTableId().equals(dataModelBase.getTask().getId()) || !"association".equals(relationship.getRelateModelType())) continue;
                masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                slaveTable = dataModelBaseMap.get(relationship.getSlaveTableId());
                modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                alias = modelAlias.get(relationship.getSlaveTableId());
                condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterTable.getId()), slaveTable);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderRelationNew(KingBaseTaskMsDataModel dataModelBase, Map<String, KingBaseDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        String mainModel = dataModelBase.getMasterTable().getSourceDataModelName();
        String mainTemplate = "FROM ${mainModel} ${alias} ";
        relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(dataModelBase.getMasterTable().getId())));
        return relationResult.toString();
    }

    public static String renderRelation(KingBaseTaskDataModel dataModelBase, Map<String, KingBaseDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<KingBaseRelationshipBase> relationships = dataModelBase.getRelationships();
        KingBaseBaseDataModel masterTable = dataModelBase.getTask();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = ((KingBaseDataModelBase)masterTable).getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (KingBaseRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                KingBaseDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderFlowTotalsRelation(KingBaseTaskDataModel dataModelBase, Map<String, KingBaseDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nINNER JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        String mainTemplate = "FROM ${mainModel} ${alias} ";
        relationResult.append(mainTemplate.replace("${mainModel}", "BPM_PROCINST_LIST_VIEW").replace("${alias}", "BPLV"));
        relationResult.append(relationTemplate.replace("${RE_MODEL}", dataModelBase.getSourceDataModelName()).replace("${ALIAS}", modelAlias.get(dataModelBase.getId())));
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        relationResult.append("ON\n").append(conditionTemplate.replace("${CONNECT}", "").replace("${FIELD}", "businessKey").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getId())).replace("${RE_FIELD}", dataModelBase.getPrimaryKey().getSourceFieldName()).replace("${RE}", "BPLV"));
        relationResult.append(relationTemplate.replace("${RE_MODEL}", dataModelBase.getTask().getSourceDataModelName()).replace("${ALIAS}", modelAlias.get(dataModelBase.getTask().getId())));
        relationResult.append("ON\n").append(conditionTemplate.replace("${CONNECT}", "").replace("${FIELD}", "taskId").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getTask().getId())).replace("${RE_FIELD}", "TASK_ID").replace("${RE}", "BPLV")).append(conditionTemplate.replace("${CONNECT}", "AND").replace("${FIELD}", "userId").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getTask().getId())).replace("${RE_FIELD}", "ASSIGNEE").replace("${RE}", "BPLV"));
        return relationResult.toString();
    }

    public static String renderFlowTotalsRelation(KingBaseTaskMsDataModel dataModelBase, Map<String, KingBaseDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nINNER JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<KingBaseRelationshipBase> relationships = dataModelBase.getRelationships();
        String mainTemplate = "FROM ${mainModel} ${alias} ";
        relationResult.append(mainTemplate.replace("${mainModel}", "BPM_PROCINST_LIST_VIEW").replace("${alias}", "BPLV"));
        relationResult.append(relationTemplate.replace("${RE_MODEL}", dataModelBase.getMasterTable().getSourceDataModelName()).replace("${ALIAS}", modelAlias.get(dataModelBase.getMasterTable().getId())));
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        relationResult.append("ON\n").append(conditionTemplate.replace("${CONNECT}", "").replace("${FIELD}", "businessKey").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getMasterTable().getId())).replace("${RE_FIELD}", dataModelBase.getPrimaryKey().getSourceFieldName()).replace("${RE}", "BPLV"));
        relationResult.append(relationTemplate.replace("${RE_MODEL}", dataModelBase.getTask().getSourceDataModelName()).replace("${ALIAS}", modelAlias.get(dataModelBase.getTask().getId())));
        relationResult.append("ON\n").append(conditionTemplate.replace("${CONNECT}", "").replace("${FIELD}", "taskId").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getTask().getId())).replace("${RE_FIELD}", "TASK_ID").replace("${RE}", "BPLV")).append(conditionTemplate.replace("${CONNECT}", "AND").replace("${FIELD}", "userId").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getTask().getId())).replace("${RE_FIELD}", "ASSIGNEE").replace("${RE}", "BPLV"));
        if (ToolUtil.isNotEmpty(relationships)) {
            for (KingBaseRelationshipBase relationship : relationships) {
                if (relationship.getMasterTableId().equals(dataModelBase.getTask().getId()) || !"association".equals(relationship.getRelateModelType())) continue;
                KingBaseDataModelBase masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                KingBaseDataModelBase slaveTable = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterTable.getId()), slaveTable);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderTotalCalculateRelation(KingBaseMsDataModel dataModelBase, Map<String, KingBaseDataModelBase> dataModelBaseMap, Map<String, Object> controllerParams) {
        boolean isPaired = false;
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<KingBaseRelationshipBase> relationships = dataModelBase.getRelationships();
        KingBaseDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = masterTable.getSourceDataModelName().toUpperCase();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
            controllerParams.put("Alias", modelAlias.get(masterId));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (KingBaseRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                KingBaseDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), dataModelBase, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (ToolUtil.isNotEmpty((Object)condition)) {
                    relationResult.append("ON\n").append(condition);
                }
                isPaired = true;
            }
        }
        controllerParams.put("isPaired", isPaired);
        return relationResult.toString();
    }

    private static String renderRelationCondition(List<KingBaseRelationshipFieldBase> relationshipFieldBases, KingBaseMsDataModel dataModelBase, String alias, String lastConnect, String mainAlias, KingBaseDataModelBase slaveModelBase) {
        StringBuilder finalCondition = new StringBuilder(128);
        String slaveModelBaseId = slaveModelBase.getId();
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            KingBaseRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = lastConnect;
            if (i == 0) {
                connect = "";
            }
            KingBaseDataModelBase masterTable = dataModelBase.getMasterTable();
            KingBaseDataModelBase slaveTables = null;
            List<KingBaseDataModelBase> slaveTableList = dataModelBase.getSlaveTables();
            String masterTableFieldId = relationshipFieldBase.getMasterTableFieldId();
            String mainField = null;
            String slaveTableFieldId = relationshipFieldBase.getSlaveTableFieldId();
            for (KingBaseDataModelBase kingBaseDataModelBase : slaveTableList) {
                if (!HussarUtils.equals((Object)slaveModelBaseId, (Object)kingBaseDataModelBase.getId())) continue;
                slaveTables = kingBaseDataModelBase;
                break;
            }
            String dependField = null;
            for (KingBaseDataModelField field : masterTable.getFields()) {
                if (!HussarUtils.equals((Object)masterTableFieldId, (Object)field.getId())) continue;
                mainField = field.getSourceFieldName();
                break;
            }
            if (slaveTables != null) {
                for (KingBaseDataModelField field : slaveTables.getFields()) {
                    if (!HussarUtils.equals((Object)slaveTableFieldId, (Object)field.getId())) continue;
                    dependField = field.getSourceFieldName();
                    break;
                }
            }
            String string = relationshipFieldBase.getSymbol();
            String connectSym = relationshipFieldBase.getConnect();
            finalCondition.append(conditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", StringUtils.isNotBlank((CharSequence)mainField) ? mainField : "").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)string)).replace("${T_RE}", alias).replace("${RE_FIELD}", StringUtils.isNotBlank((CharSequence)dependField) ? dependField : "").replace("${RE}", mainAlias));
            lastConnect = connectSym;
        }
        return finalCondition.toString();
    }

    private static String renderRelationCondition(List<KingBaseRelationshipFieldBase> relationshipFieldBases, KingBaseDataModelBase masterModelBase, String alias, String lastConnect, String mainAlias, KingBaseDataModelBase slaveModelBase) {
        StringBuilder finalCondition = new StringBuilder(128);
        String slaveModelBaseId = slaveModelBase.getId();
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            KingBaseRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = lastConnect;
            if (i == 0) {
                connect = "";
            }
            String masterTableFieldId = relationshipFieldBase.getMasterTableFieldId();
            String mainField = null;
            String slaveTableFieldId = relationshipFieldBase.getSlaveTableFieldId();
            String dependField = null;
            for (KingBaseDataModelField field : masterModelBase.getFields()) {
                if (!HussarUtils.equals((Object)masterTableFieldId, (Object)field.getId())) continue;
                mainField = field.getSourceFieldName();
                break;
            }
            for (KingBaseDataModelField field : slaveModelBase.getFields()) {
                if (!HussarUtils.equals((Object)slaveTableFieldId, (Object)field.getId())) continue;
                dependField = field.getSourceFieldName();
                break;
            }
            String symbol = relationshipFieldBase.getSymbol();
            String connectSym = relationshipFieldBase.getConnect();
            finalCondition.append(conditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", StringUtils.isNotBlank((CharSequence)mainField) ? mainField : "").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)symbol)).replace("${T_RE}", alias).replace("${RE_FIELD}", StringUtils.isNotBlank((CharSequence)dependField) ? dependField : "").replace("${RE}", mainAlias));
            lastConnect = connectSym;
        }
        return finalCondition.toString();
    }
}

