/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.element.base;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class KingBaseBaseConnector {
    public static TableInfoDto tableInfoInEdit(SysDataSource sysDataSource, KingBaseDataModelBase dataModel) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(dataModel.getSourceDataModelName());
        tableDto.setPollName(dataModel.getDataSourceName());
        tableDto.setTableAlias(dataModel.getName());
        tableDto.setDatasourceId(sysDataSource.getId());
        tableDto.setColumnList(KingBaseBaseConnector.transfer(dataModel.getFields()));
        return tableDto;
    }

    public static TableInfoDto tableInfoInCreate(SysDataSource sysDataSource, KingBaseDataModelBase dataModel) {
        TableInfoDto tableDto = KingBaseBaseConnector.tableInfoInEdit(sysDataSource, dataModel);
        tableDto.setTableDec(dataModel.getTableDesc());
        return tableDto;
    }

    public static List<ColumnInfoDto> transferColumn(List<KingBaseDataModelField> fields, String updateType) {
        ArrayList<ColumnInfoDto> columns = new ArrayList<ColumnInfoDto>();
        for (KingBaseDataModelField x : fields) {
            MetadataColumn metadataColumn = KingBaseBaseConnector.getMetadataColumn(x);
            ColumnInfoDto columnInfoDto = (ColumnInfoDto)BeanUtil.copyProperties((Object)metadataColumn, ColumnInfoDto.class);
            String isPk = "primary".equals(x.getUsage()) ? "1" : "0";
            String isRequired = x.getDataIsEmpty() ? "1" : "0";
            columnInfoDto.setPk(isPk);
            columnInfoDto.setIncrease("0");
            columnInfoDto.setRequired(isRequired);
            if (ToolUtil.isNotEmpty((Object)updateType)) {
                columnInfoDto.setOperation(updateType);
            }
            columns.add(columnInfoDto);
        }
        return columns;
    }

    private static List<MetadataColumn> transfer(List<KingBaseDataModelField> fields) {
        ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
        for (KingBaseDataModelField x : fields) {
            MetadataColumn metadataColumn = KingBaseBaseConnector.getMetadataColumn(x);
            columns.add(metadataColumn);
        }
        return columns;
    }

    private static MetadataColumn getMetadataColumn(KingBaseDataModelField modelField) {
        Optional engineColumnType;
        String fieldSourceDataType = modelField.getSourceDataType();
        int preIndex = fieldSourceDataType.indexOf("(");
        String dataType = preIndex > -1 ? fieldSourceDataType.substring(0, preIndex) : modelField.getSourceDataType();
        MetadataColumn metadataColumn = new MetadataColumn();
        metadataColumn.setColumnAlias(modelField.getName());
        metadataColumn.setColumnName(modelField.getSourceFieldName());
        metadataColumn.setColumnComment(modelField.getComment());
        metadataColumn.setDataType(dataType);
        metadataColumn.setDataDot(Integer.valueOf(modelField.getDataDot()));
        metadataColumn.setDataLength(Long.valueOf(modelField.getDataLength()));
        metadataColumn.setDataIsEmpty(Integer.valueOf(modelField.getDataIsEmpty() ? 1 : 0));
        if (ToolUtil.isNotEmpty((Object)modelField.getUsage())) {
            if ("primary".equals(modelField.getUsage())) {
                metadataColumn.setPrimarys("1");
            }
            metadataColumn.setPurpose(modelField.getUsage());
        }
        if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)modelField.getDataType())).isPresent()) {
            metadataColumn.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
            metadataColumn.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        }
        return metadataColumn;
    }
}

