/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.customOption.task;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.KingBaseCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseCustomOperation;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component(value="KINGBASETASKCUSTOM_OPTION")
public class KingBaseTaskCustomOption
implements KingBaseCustomOperation<KingBaseTaskDataModel, KingBaseTaskDataModelDTO> {
    public static final String CUSTOM_OPTION = "KINGBASETASKCUSTOM_OPTION";

    @Override
    public void publishCustomOption(KingBaseBackCtx<KingBaseTaskDataModel, KingBaseTaskDataModelDTO> backCtx) throws LcdpException {
        this.publishTaskDataBackFill(backCtx);
    }

    private void publishTaskDataBackFill(KingBaseBackCtx<KingBaseTaskDataModel, KingBaseTaskDataModelDTO> backCtx) throws LcdpException {
        if (ToolUtil.isEmpty((Object)backCtx.getParams()) || ToolUtil.isEmpty(backCtx.getParams().get("identity"))) {
            return;
        }
        KingBaseTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        KingBaseTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        if (ToolUtil.isEmpty(useDataModelDTO.getCustomCodeGenerateInfo())) {
            useDataModelDTO.setCustomCodeGenerateInfo(new HashMap<String, KingBaseCodeGenerateInfo>());
        }
        useDataModelDTO.getCustomCodeGenerateInfo().put(useDataModelBase.getId(), this.genTaskDataBackFillCode(backCtx));
    }

    private KingBaseCodeGenerateInfo genTaskDataBackFillCode(KingBaseBackCtx<KingBaseTaskDataModel, KingBaseTaskDataModelDTO> backCtx) throws LcdpException {
        KingBaseTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        KingBaseTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        KingBaseBaseDataModel task = useDataModelBase.getTask();
        String taskId = task.getId();
        KingBaseDataModelBaseDTO userTaskModelDTO = useDataModelDTO.getDataModelDtoMap().get(taskId);
        KingBaseDataModelBaseDTO userBusinessModelDTO = useDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getId());
        String modulePath = useDataModelDTO.getTablePath().toLowerCase();
        String fileName = userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl";
        String writePath = modulePath + File.separator + "Task".toLowerCase() + File.separator + fileName + ".java";
        String dataBackFillPath = "template/kingbase/taskbackcode/code/task_data_backfill_service_impl.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("package", userTaskModelDTO.getPackageInfo().get("Task"));
        params.put("className", fileName);
        params.put("identity", backCtx.getParams().get("identity"));
        TreeSet<String> imports = new TreeSet<String>();
        params.put("implementServiceNameImportInfo", "com.jxdinfo.hussar.workflow.task.model.service.TaskModelService");
        params.put("implementServiceName", "TaskModelService");
        params.put("ProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto");
        params.put("DeletedProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto");
        params.put("ProcessNodeInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto");
        params.put("CompleteTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto");
        params.put("UpdateTaskUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto");
        params.put("WorkflowUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto");
        params.put("TaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto");
        params.put("DeletedTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto");
        params.put("taskEntity", userTaskModelDTO.getEntityName());
        params.put("taskEntityImportInfo", userTaskModelDTO.getImportInfo().get("Entity"));
        params.put("taskServiceName", userTaskModelDTO.getServiceName());
        params.put("taskServiceImportInfo", userTaskModelDTO.getImportInfo().get("Service"));
        params.put("businessServiceName", userBusinessModelDTO.getServiceName());
        params.put("businessServiceImportInfo", userBusinessModelDTO.getImportInfo().get("Service"));
        params.put("businessEntity", userBusinessModelDTO.getEntityName());
        params.put("businessEntityImportInfo", userBusinessModelDTO.getImportInfo().get("Entity"));
        HashMap<String, String> businessColumn = new HashMap<String, String>();
        List<KingBaseDataModelFieldDto> businessFields = userBusinessModelDTO.getFields();
        for (KingBaseDataModelFieldDto kingBaseDataModelFieldDto : businessFields) {
            if (!ToolUtil.isNotEmpty((Object)kingBaseDataModelFieldDto.getFill())) continue;
            businessColumn.put(kingBaseDataModelFieldDto.getFill(), kingBaseDataModelFieldDto.getName());
            if (!"primary".equals(kingBaseDataModelFieldDto.getFill())) continue;
            params.put("primaryType", kingBaseDataModelFieldDto.getColumnType().getType());
            if (!ToolUtil.isNotEmpty((Object)kingBaseDataModelFieldDto.getColumnType().getImportT())) continue;
            imports.add(kingBaseDataModelFieldDto.getColumnType().getImportT());
        }
        params.put("businessColumn", businessColumn);
        List<KingBaseDataModelField> fields = task.getFields();
        for (KingBaseDataModelField field : fields) {
            if ("foreign".equals(field.getUsage())) {
                params.put("taskForeign", field.getSourceFieldName());
            }
            if (!"taskId".equals(field.getName())) continue;
            params.put("taskTaskId", field.getSourceFieldName());
        }
        params.put("dataSourceName", useDataModelBase.getDataSourceName());
        params.put("imports", imports);
        KingBaseCodeGenerateInfo kingBaseCodeGenerateInfo = new KingBaseCodeGenerateInfo();
        kingBaseCodeGenerateInfo.setFileWriteRelativePath(writePath);
        kingBaseCodeGenerateInfo.setFileContent(RenderUtil.renderTemplate((String)dataBackFillPath, params));
        kingBaseCodeGenerateInfo.setFileType("serviceImpl");
        kingBaseCodeGenerateInfo.setFileId(useDataModelDTO.getId());
        kingBaseCodeGenerateInfo.setFileName(userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl" + ".java");
        return kingBaseCodeGenerateInfo;
    }
}

