/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class KingBasePublicEnclosure {
    private static FormDesignProperties formDesignProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);

    public static void enclosure(KingBaseDataModelBase dataModelBase, KingBaseDataModelBaseDTO dataModelBaseDTO) throws CloneNotSupportedException, LcdpException {
        boolean ignoreStrategy = false;
        dataModelBaseDTO.setDataSourceName(dataModelBase.getDataSourceName());
        dataModelBaseDTO.setId(dataModelBase.getId());
        dataModelBaseDTO.setName(dataModelBase.getName());
        dataModelBaseDTO.setComment(dataModelBase.getComment());
        dataModelBaseDTO.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelBaseDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setVoName(NamingStrategy.capitalFirst((String)(EnclosureUtil.processName((String)dataModelBaseDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null) + "VO")));
        dataModelBaseDTO.setMapperName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setXmlName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setServiceName(dataModelBaseDTO.getEntityName() + "Service");
        dataModelBaseDTO.setServiceImplName(dataModelBaseDTO.getEntityName() + "ServiceImpl");
        dataModelBaseDTO.setControllerName(dataModelBaseDTO.getEntityName() + "Controller");
        dataModelBaseDTO.setModuleName(dataModelBase.getModelPath().replace("/", "."));
        dataModelBaseDTO.setBusName(AppContextUtil.getBusName());
        dataModelBaseDTO.setSceneName(dataModelBaseDTO.getModuleName().substring(1));
        dataModelBaseDTO.setDictName(dataModelBaseDTO.getEntityName() + NamingStrategy.capitalFirst((String)"dict"));
        dataModelBaseDTO.setExtension(dataModelBase.isExtension());
        dataModelBaseDTO.setTablePath(dataModelBase.getModelPath() + "/" + dataModelBase.getName());
        List<KingBaseDataModelField> dataModelFieldBases = dataModelBase.getFields();
        ArrayList<KingBaseDataModelFieldDto> tableFields = new ArrayList<KingBaseDataModelFieldDto>();
        for (KingBaseDataModelField dataModelFieldBase : dataModelFieldBases) {
            KingBaseDataModelFieldDto tableField = new KingBaseDataModelFieldDto();
            tableField.setKeyFlag("primary".equals(dataModelFieldBase.getUsage()));
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setId(dataModelFieldBase.getId());
            tableField.setExtend(dataModelFieldBase.isExtend());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (!Objects.equals(Optional.of(dataModelFieldBase).map(KingBaseDataModelField::getUpdateStrategy).orElse(null), "not_null")) {
                ignoreStrategy = true;
            }
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            if ("date".equals(dataModelFieldBase.getDataType())) {
                ignoreStrategy = true;
            }
            tableField.setSourceDataModelId(dataModelFieldBase.getSourceDataModelId());
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFields(tableFields);
        if (ignoreStrategy) {
            dataModelBaseDTO.addEntityImport("com.baomidou.mybatisplus.annotation.FieldStrategy;");
        }
        if (dataModelBaseDTO.isUseMybatisPlus()) {
            dataModelBaseDTO.addEntityImport("com.baomidou.mybatisplus.annotation.TableName");
        }
        Map packageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        dataModelBaseDTO.setPackageInfo(packageInfo);
        Map<String, String> importInfo = KingBasePublicEnclosure.getImportInfo(packageInfo, dataModelBaseDTO);
        dataModelBaseDTO.setImportInfo(importInfo);
        ArrayList<KingBaseDataModelFieldDto> voFields = new ArrayList<KingBaseDataModelFieldDto>();
        for (KingBaseDataModelFieldDto tableField : tableFields) {
            voFields.add(tableField.clone());
        }
        VoGeneratorInfo voGeneratorInfo = new VoGeneratorInfo();
        voGeneratorInfo.setFields(voFields);
        dataModelBaseDTO.setVoGeneratorInfo(voGeneratorInfo);
        boolean enableSwaggerRender = formDesignProperties.isEnableSwaggerRender();
        if (enableSwaggerRender) {
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.Api");
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.ApiOperation");
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.ApiParam");
        }
        dataModelBaseDTO.setEnableSwaggerRender(enableSwaggerRender);
        if (HussarUtils.isNotEmpty((Object)AppContextUtil.getAppInfo())) {
            String modulePath = FileUtil.systemPath((String[])new String[]{dataModelBaseDTO.getTablePath()}).replace("/", "").replace("\\", "").replace("//", "").replace("\\\\", "");
            dataModelBaseDTO.addControllerExpansionModelId(String.format("%s%s", AppContextUtil.getAppInfo().getEnglishName(), modulePath));
        }
    }

    public static Map<String, String> getImportInfo(Map<String, String> packageInfo, KingBaseDataModelBaseDTO dataModelDto) {
        HashMap<String, String> importInfo = new HashMap<String, String>();
        importInfo.put("Entity", packageInfo.get("Entity") + "." + dataModelDto.getEntityName());
        importInfo.put("Mapper", packageInfo.get("Mapper") + "." + dataModelDto.getMapperName());
        importInfo.put("Xml", packageInfo.get("Xml") + "." + dataModelDto.getXmlName());
        importInfo.put("Service", packageInfo.get("Service") + "." + dataModelDto.getServiceName());
        importInfo.put("ServiceImpl", packageInfo.get("ServiceImpl") + "." + dataModelDto.getServiceImplName());
        importInfo.put("Controller", packageInfo.get("Controller") + "." + dataModelDto.getControllerName());
        importInfo.put("dict", packageInfo.get("dict") + "." + dataModelDto.getDictName());
        importInfo.put("dto", packageInfo.get("dto") + "." + dataModelDto.getEntityName() + "Qo");
        importInfo.put("VO", packageInfo.get("VO") + "." + dataModelDto.getVoName());
        return importInfo;
    }

    public static void setTableDescByModelBase(KingBaseMsDataModelDTO dataModelBaseDTO, Map<String, KingBaseDataModelBase> dataModelBaseMap) {
        List<KingBaseDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        for (KingBaseDataModelFieldDto field : fields) {
            if (!dataModelBaseMap.containsKey(field.getSourceDataModelId())) continue;
            field.setTableDesc(dataModelBaseMap.get(field.getSourceDataModelId()).getTableDesc());
        }
    }
}

