/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseEnclosure;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseRender;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.querycondition.KingBaseQueryCondition;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.querycondition.KingBaseQueryObject;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.sortcondition.KingBaseSortCondition;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.sortcondition.KingBaseSortConditionField;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseDataModelUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KingBaseMsDataModel
extends KingBaseDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(KingBaseMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<KingBaseQueryCondition> queryConditions;
    private List<KingBaseQueryObject> queryObject;
    private KingBaseDataModelBase masterTable;
    private List<KingBaseDataModelBase> slaveTables;
    private List<KingBaseRelationshipBase> relationships;
    private boolean logicallyDelete;
    private KingBaseBaseDataModel taskModel;
    private List<KingBaseSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"KINGBASE.MASTER_SLAVE", KingBaseMsDataModel.class);
    }

    @Override
    public KingBaseMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        KingBaseMsDataModel KingBaseMsDataModel2;
        try {
            ArrayList<KingBaseDataModelField> fieldList = new ArrayList<KingBaseDataModelField>();
            KingBaseMsDataModel2 = (KingBaseMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), KingBaseMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                KingBaseDataModelBase master = KingBaseDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(KingBaseMsDataModel2.getName() + "Master");
                KingBaseMsDataModel2.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<KingBaseDataModelBase> slaveTables = new ArrayList<KingBaseDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    KingBaseDataModelBase slaveTable = KingBaseDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (KingBaseRelationshipBase relationship : KingBaseMsDataModel2.getRelationships()) {
                    KingBaseDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(KingBaseBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    KingBaseDataModelField kingBaseDataModelField = new KingBaseDataModelField();
                    kingBaseDataModelField.setId(UUID.randomUUID().toString());
                    kingBaseDataModelField.setName(dataModelBase.getName());
                    kingBaseDataModelField.setComment(dataModelBase.getComment());
                    kingBaseDataModelField.setSourceDataModelId(dataModelBase.getId());
                    kingBaseDataModelField.setDataType("array");
                    fieldList.add(kingBaseDataModelField);
                }
                KingBaseMsDataModel2.setSlaveTables(slaveTables);
            }
            KingBaseMsDataModel2.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return KingBaseMsDataModel2;
    }

    @Override
    public KingBaseEnclosure<KingBaseDataModelBase> enclosure() throws LcdpException {
        return KingBaseModelBeanUtil.getEnclosureBean("KINGBASE", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public KingBaseRender<KingBaseDataModelBase, KingBaseDataModelBaseDTO> render() throws LcdpException {
        return KingBaseModelBeanUtil.getRenderBean("KINGBASE", FUNCTION_TYPE, "RENDER");
    }

    public KingBaseBaseDataModel getTaskModel() {
        return this.taskModel;
    }

    public void setTaskModel(KingBaseBaseDataModel taskModel) {
        this.taskModel = taskModel;
    }

    public KingBaseDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(KingBaseDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<KingBaseDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<KingBaseDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<KingBaseRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<KingBaseRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<KingBaseQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<KingBaseQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<KingBaseQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<KingBaseQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<KingBaseSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (KingBaseSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (KingBaseSortConditionField field : condition.getFields()) {
                    Map<String, String> fielKingBaseap;
                    String fieldName;
                    if (HussarUtils.isEmpty((Object)field.getParentModelId())) {
                        field.setParentModelId(field.getFromModelIdSort());
                    }
                    KingBaseDataModelBase dataModelBase = this.masterTable;
                    if (!this.masterTable.getId().equals(field.getFromModelIdSort())) {
                        for (KingBaseDataModelBase modelBase : this.slaveTables) {
                            if (!modelBase.getId().equals(field.getFromModelIdSort())) continue;
                            dataModelBase = modelBase;
                            break;
                        }
                    }
                    if (HussarUtils.equals((Object)(fieldName = (fielKingBaseap = dataModelBase.getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName))).get(field.getFromModelFieldIdSort())), (Object)field.getFromModelFieldSort())) continue;
                    field.setFromModelFieldSort(fieldName);
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<KingBaseSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public KingBaseQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (KingBaseQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public KingBaseSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (KingBaseSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                KingBaseRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<KingBaseDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> tableContrastModel(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<KingBaseDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        List<KingBaseDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (KingBaseDataModelBase extSlaveTable : extSlaveTables) {
            ContrastVO<KingBaseDataModelField> kingBaseDataModelFieldContrastVO = extSlaveTable.tableContrastModel(fieldsContrastParam).get(0);
            if (HussarUtils.isNotEmpty(kingBaseDataModelFieldContrastVO) && HussarUtils.isNotEmpty((Object)kingBaseDataModelFieldContrastVO.getTableFields())) {
                for (KingBaseDataModelField field : kingBaseDataModelFieldContrastVO.getTableFields()) {
                    field.setExtension(true);
                }
            }
            tableContrast.add(kingBaseDataModelFieldContrastVO);
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> tableContrastModelIn(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        ArrayList<ContrastVO<KingBaseDataModelField>> tableContrast = new ArrayList<ContrastVO<KingBaseDataModelField>>();
        List tableInfos = DataModelUtil.filterInTables((String)this.getDataSourceName(), (String)"BASE TABLE", this.getTableNames(fieldsContrastParam));
        TableInfo masterTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> this.masterTable.getSourceDataModelName().toLowerCase().equals(table.getName())).findFirst().orElse(null) : null;
        tableContrast.add(this.masterTable.tableContrastModel(masterTableInfo, fieldsContrastParam));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (KingBaseDataModelBase slaveTable : this.slaveTables) {
            if (!HussarUtils.isEmpty(map.get(slaveTable.getSourceDataModelName()))) continue;
            String slaveUpperCaseName = slaveTable.getSourceDataModelName().toLowerCase();
            TableInfo slaveTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> slaveUpperCaseName.equals(table.getName())).findFirst().orElse(null) : null;
            tableContrast.add(slaveTable.tableContrastModel(slaveTableInfo, fieldsContrastParam));
            map.put(slaveTable.getSourceDataModelName(), true);
        }
        List<KingBaseDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (KingBaseDataModelBase extSlaveTable : extSlaveTables) {
            if (!HussarUtils.isEmpty(map.get(extSlaveTable.getSourceDataModelName()))) continue;
            String extSlaveUpperCaseName = extSlaveTable.getSourceDataModelName().toLowerCase();
            TableInfo slaveTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> extSlaveUpperCaseName.equals(table.getName())).findFirst().orElse(null) : null;
            ContrastVO<KingBaseDataModelField> KingBaseDataModelFieldContrastVO = extSlaveTable.tableContrastModel(slaveTableInfo, fieldsContrastParam);
            if (HussarUtils.isNotEmpty(KingBaseDataModelFieldContrastVO) && HussarUtils.isNotEmpty((Object)KingBaseDataModelFieldContrastVO.getTableFields())) {
                for (KingBaseDataModelField field : KingBaseDataModelFieldContrastVO.getTableFields()) {
                    field.setExtension(true);
                }
            }
            tableContrast.add(KingBaseDataModelFieldContrastVO);
            map.put(extSlaveTable.getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> modelContrastTable(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<KingBaseDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            if (!HussarUtils.isEmpty(map.get(this.slaveTables.get(i).getSourceDataModelName()))) continue;
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
            map.put(this.slaveTables.get(i).getSourceDataModelName(), true);
        }
        List<KingBaseDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (KingBaseDataModelBase extSlaveTable : extSlaveTables) {
            if (!HussarUtils.isEmpty(map.get(extSlaveTable.getSourceDataModelName()))) continue;
            ContrastVO<KingBaseDataModelField> kingBaseDataModelFieldContrastVO = extSlaveTable.modelContrastTable(fieldsContrastParam).get(0);
            if (HussarUtils.isNotEmpty(kingBaseDataModelFieldContrastVO) && HussarUtils.isNotEmpty((Object)kingBaseDataModelFieldContrastVO.getTableFields())) {
                for (KingBaseDataModelField field : kingBaseDataModelFieldContrastVO.getTableFields()) {
                    field.setExtension(true);
                }
            }
            tableContrast.add(kingBaseDataModelFieldContrastVO);
            map.put(extSlaveTable.getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ContrastVO<KingBaseDataModelField>> modelContrastTableIn(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        ArrayList<ContrastVO<KingBaseDataModelField>> tableContrast = new ArrayList<ContrastVO<KingBaseDataModelField>>();
        List tableInfos = DataModelUtil.filterInTables((String)this.getDataSourceName(), (String)"BASE TABLE", this.getTableNames(fieldsContrastParam));
        TableInfo masterTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> this.masterTable.getSourceDataModelName().toLowerCase().equals(table.getName())).findFirst().orElse(null) : null;
        tableContrast.add(this.masterTable.modelContrastTable(masterTableInfo, fieldsContrastParam));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (KingBaseDataModelBase kingBaseDataModelBase : this.slaveTables) {
            if (!HussarUtils.isEmpty(map.get(kingBaseDataModelBase.getSourceDataModelName()))) continue;
            String slaveUpperCaseName = kingBaseDataModelBase.getSourceDataModelName().toLowerCase();
            TableInfo slaveTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> slaveUpperCaseName.equals(table.getName())).findFirst().orElse(null) : null;
            tableContrast.add(kingBaseDataModelBase.modelContrastTable(slaveTableInfo, fieldsContrastParam));
            map.put(kingBaseDataModelBase.getSourceDataModelName(), true);
        }
        List<KingBaseDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (KingBaseDataModelBase extSlaveTable : extSlaveTables) {
            if (!HussarUtils.isEmpty(map.get(extSlaveTable.getSourceDataModelName()))) continue;
            String extSlaveUpperCaseName = extSlaveTable.getSourceDataModelName().toLowerCase();
            TableInfo slaveTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> extSlaveUpperCaseName.equals(table.getName())).findFirst().orElse(null) : null;
            ContrastVO<KingBaseDataModelField> KingBaseDataModelFieldContrastVO = extSlaveTable.modelContrastTable(slaveTableInfo, fieldsContrastParam);
            if (HussarUtils.isNotEmpty(KingBaseDataModelFieldContrastVO) && HussarUtils.isNotEmpty((Object)KingBaseDataModelFieldContrastVO.getTableFields())) {
                for (KingBaseDataModelField field : KingBaseDataModelFieldContrastVO.getTableFields()) {
                    field.setExtension(true);
                }
            }
            tableContrast.add(KingBaseDataModelFieldContrastVO);
            map.put(extSlaveTable.getSourceDataModelName(), true);
        }
        if (HussarUtils.isNotEmpty((Object)this.taskModel)) {
            void var7_11;
            if (HussarUtils.isNotEmpty((Object)tableInfos)) {
                TableInfo tableInfo = tableInfos.stream().filter(table -> this.taskModel.getTableName(fieldsContrastParam).equals(table.getName())).findFirst().orElse(null);
            } else {
                Object var7_10 = null;
            }
            tableContrast.add(this.taskModel.modelContrastTable((TableInfo)var7_11, fieldsContrastParam));
        }
        return tableContrast;
    }

    public List<String> getTableNames(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws LcdpException {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.masterTable.getTableName(fieldsContrastParam));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (KingBaseDataModelBase slaveTable : this.slaveTables) {
            if (!HussarUtils.isEmpty(map.get(slaveTable.getSourceDataModelName()))) continue;
            tableNames.add(slaveTable.getTableName(fieldsContrastParam));
            map.put(slaveTable.getSourceDataModelName(), true);
        }
        List<KingBaseDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (KingBaseDataModelBase extSlaveTable : extSlaveTables) {
            if (!HussarUtils.isEmpty(map.get(extSlaveTable.getSourceDataModelName()))) continue;
            tableNames.add(extSlaveTable.getTableName(fieldsContrastParam));
            map.put(extSlaveTable.getSourceDataModelName(), true);
        }
        if (HussarUtils.isNotEmpty((Object)this.taskModel)) {
            tableNames.add(this.taskModel.getTableName(fieldsContrastParam));
        }
        return tableNames;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId, Map<String, List<JSONObject>> extFields, List<JSONObject> extSlaveTables) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        }
        List<KingBaseDataModelBase> extSlaveTableDto = this.extSlaveTables(extSlaveTables);
        for (KingBaseDataModelBase extSlaveTable : extSlaveTableDto) {
            details.add(extSlaveTable.checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        List<KingBaseDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (KingBaseDataModelBase extSlaveTable : extSlaveTables) {
            extSlaveTable.updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws Exception {
        StringBuilder sql = new StringBuilder(this.masterTable.copyTableByModel(fieldsContrastParam));
        for (KingBaseDataModelBase slaveTable : this.slaveTables) {
            sql.append(slaveTable.copyTableByModel(fieldsContrastParam));
        }
        List<KingBaseDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (KingBaseDataModelBase extSlaveTable : extSlaveTables) {
            sql.append(extSlaveTable.copyTableByModel(fieldsContrastParam));
        }
        return sql.toString();
    }

    public KingBaseDataModelField getDeleteFlag() {
        return this.getMasterTable().getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public KingBaseDataModelField getPrimaryKey() {
        return this.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() throws LcdpException {
        JSONObject dataModelJsonExt;
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        List<KingBaseDataModelBase> slaveTables = this.getSlaveTables();
        for (KingBaseDataModelBase slaveTable : slaveTables) {
            KingBaseDataModelField kingBaseDataModelField = slaveTable.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(new KingBaseDataModelField());
            HashMap<String, Object> val = new HashMap<String, Object>();
            val.put("name", slaveTable.getName());
            val.put("sourceDataModelName", slaveTable.getSourceDataModelName());
            val.put("comment", slaveTable.getComment());
            val.put("primary", kingBaseDataModelField.getName());
            val.put("fields", slaveTable.getFields());
            boolean association = this.getRelationships().stream().anyMatch(relationship -> relationship.getRelateModelType().equals(ASSOCIATION) && relationship.getSlaveTableId().equals(slaveTable.getId()));
            val.put(ASSOCIATION, association);
            val.put("type", association ? ASSOCIATION : COLLECTION);
            map.put(slaveTable.getId(), val);
        }
        HashMap<String, String> val = new HashMap<String, String>();
        val.put("name", this.masterTable.getName());
        val.put("sourceDataModelName", this.masterTable.getSourceDataModelName());
        val.put("type", "master");
        map.put(this.masterTable.getId(), val);
        if (AppContextUtil.isHTSZMode() && AppContextUtil.isExtension() && HussarUtils.isNotEmpty((Object)(dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)this.getId())))) {
            JSONArray slaveTablesJson = (JSONArray)dataModelJsonExt.get((Object)SLAVE_KEY);
            JSONArray relationshipsJson = (JSONArray)dataModelJsonExt.get((Object)"relationships");
            ArrayList<KingBaseRelationshipBase> relationshipBaseList = new ArrayList<KingBaseRelationshipBase>();
            if (HussarUtils.isNotEmpty((Object)relationshipsJson)) {
                for (Object o : relationshipsJson) {
                    KingBaseRelationshipBase relationshipBase = (KingBaseRelationshipBase)JsonUtil.parse((String)o.toString(), KingBaseRelationshipBase.class);
                    relationshipBaseList.add(relationshipBase);
                }
            }
            if (HussarUtils.isNotEmpty((Object)slaveTablesJson) && HussarUtils.isNotEmpty(relationshipBaseList)) {
                for (Object slaveObj : slaveTablesJson) {
                    KingBaseBaseDataModel parse = (KingBaseBaseDataModel)JsonUtil.parse((String)slaveObj.toString(), KingBaseBaseDataModel.class);
                    KingBaseDataModelField kingBaseDataModelField = parse.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(new KingBaseDataModelField());
                    HashMap<String, Object> valext = new HashMap<String, Object>();
                    valext.put("name", parse.getName());
                    valext.put("sourceDataModelName", parse.getSourceDataModelName());
                    valext.put("comment", parse.getComment());
                    valext.put("primary", kingBaseDataModelField.getName());
                    valext.put("fields", parse.getFields());
                    boolean association = relationshipBaseList.stream().anyMatch(relationship -> relationship.getRelateModelType().equals(ASSOCIATION) && relationship.getSlaveTableId().equals(parse.getId()));
                    valext.put(ASSOCIATION, association);
                    valext.put("type", association ? ASSOCIATION : COLLECTION);
                    map.put(parse.getId(), valext);
                }
            }
        }
        return map;
    }

    private List<KingBaseDataModelBase> extSlaveTables(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws LcdpException {
        List slaveTables;
        ArrayList<KingBaseDataModelBase> extSlaveTables = new ArrayList<KingBaseDataModelBase>();
        if (HussarUtils.isNotEmpty((Object)fieldsContrastParam.getSlaveTables()) && HussarUtils.isNotEmpty((Object)(slaveTables = fieldsContrastParam.getSlaveTables()))) {
            for (JSONObject slaveTable : slaveTables) {
                KingBaseDataModelBase extSlaveTable = KingBaseDataModelUtil.transfer(slaveTable);
                extSlaveTables.add(extSlaveTable);
            }
        }
        return extSlaveTables;
    }

    private List<KingBaseDataModelBase> extSlaveTables(List<JSONObject> slaveTables) throws LcdpException {
        ArrayList<KingBaseDataModelBase> extSlaveTables = new ArrayList<KingBaseDataModelBase>();
        if (HussarUtils.isNotEmpty(slaveTables)) {
            for (JSONObject slaveTable : slaveTables) {
                KingBaseDataModelBase extSlaveTable = KingBaseDataModelUtil.transfer(slaveTable);
                extSlaveTables.add(extSlaveTable);
            }
        }
        return extSlaveTables;
    }
}

