/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.masterslave;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.function.visitor.constant.KingBaseConstUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.visitor.masterslave.util.KingBaseMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEMASTER_SLAVEextensionInsertOrUpdatePlus")
public class KingBaseMsFormExtendSlaveTableSavePlusVisitor
implements KingBaseOperationVisitor<KingBaseMsDataModel, KingBaseMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseMsFormExtendSlaveTableSavePlusVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEMASTER_SLAVEextensionInsertOrUpdatePlus";

    @Override
    public void visit(KingBaseBackCtx<KingBaseMsDataModel, KingBaseMsDataModelDTO> backCtx, KingBaseDataModelOperation operation) throws LcdpException {
        boolean plusFlag;
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        KingBaseMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        KingBaseMsDataModelDTO kingbaseMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = operation.getParams();
        KingBaseDataModelFieldDto keyField = kingbaseMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Boolean> slaveTablePlusSave = Maps.newHashMapWithExpectedSize((int)0);
        if (HussarUtils.isNotEmpty(operation.getParams()) && HussarUtils.isNotEmpty((Object)operation.getParams().get("slaveTablePlusSave"))) {
            slaveTablePlusSave = (Map)operation.getParams().get("slaveTablePlusSave");
        }
        controllerParams.put("slaveTablePlusSave", slaveTablePlusSave);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        HashSet<String> extendModelId = new HashSet<String>();
        for (KingBaseDataModelBase kingBaseDataModelBase : dataModelBase.getSlaveTables()) {
            if (kingBaseDataModelBase.isExtension()) {
                extendModelId.add(kingBaseDataModelBase.getId());
            }
            KingBaseDataModelBaseDTO kingbaseDataModelBaseDTO = kingbaseMsDataModelDTO.getDataModelDtoMap().get(kingBaseDataModelBase.getId());
            String slaveModelName = kingBaseDataModelBase.getName();
            for (KingBaseDataModelFieldDto field : kingbaseDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(field.getFill())) continue;
                relationTagKeys.put(slaveModelName, field.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        if (plusFlag = "extensionInsertOrUpdatePlus".equals(operation.getType())) {
            for (KingBaseRelationshipDTO relationshipDTO : kingbaseMsDataModelDTO.getRelationshipDtoList()) {
                if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
                slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
            }
            for (KingBaseDataModelBase modelBase : dataModelBase.getSlaveTables()) {
                isLogicallyDelete.put(modelBase.getId(), ((KingBaseBaseDataModel)modelBase).getLogicallyDelete());
                KingBaseDataModelBaseDTO kingbaseDataModelBaseDTO = kingbaseMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
                String slaveModelName = modelBase.getName();
                capitalNameList.put(slaveModelName, KingBaseMasterSlaveUtil.getCapitalName(slaveModelName));
                for (KingBaseDataModelField kingBaseDataModelField : modelBase.getFields()) {
                    if (!"delDefFlag".equals(kingBaseDataModelField.getUsage())) continue;
                    logicallyDelField.put(slaveModelName, kingBaseDataModelField.getName());
                }
                for (KingBaseDataModelFieldDto kingBaseDataModelFieldDto : kingbaseDataModelBaseDTO.getFields()) {
                    if ("primary".equals(kingBaseDataModelFieldDto.getFill())) {
                        primaryKeys.put(slaveModelName, kingBaseDataModelFieldDto.getCapitalName());
                    }
                    if (!"foreign".equals(kingBaseDataModelFieldDto.getFill())) continue;
                    foreignKeys.put(slaveModelName, kingBaseDataModelFieldDto.getCapitalName());
                }
            }
        }
        controllerParams.put("table", kingbaseMsDataModelDTO);
        controllerParams.put("extendModelIds", extendModelId);
        this.masterSlaveCode(backCtx, controllerParams);
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        if (plusFlag) {
            controllerParams.put("primaryKeys", primaryKeys);
            controllerParams.put("foreignKeys", foreignKeys);
            controllerParams.put("slaveTable", KingBaseMasterSlaveUtil.ofSlaveParam(dataModelBase, kingbaseMsDataModelDTO));
            controllerParams.put("isPlusSave", true);
            controllerParams.put("isLogicallyDelete", isLogicallyDelete);
            controllerParams.put("logicallyDelField", logicallyDelField);
            controllerParams.put("capitalNameList", capitalNameList);
        }
        String string = "template/kingbase/masterslavebackcode/addorupdate/serviceSlaveTableExtendInsertOrUpdate_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.TypeReference");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void masterSlaveCode(KingBaseBackCtx<KingBaseMsDataModel, KingBaseMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        KingBaseMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        KingBaseMsDataModelDTO kingbaseMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<KingBaseRelationshipDTO> relationshipDtoList = kingbaseMsDataModelDTO.getRelationshipDtoList();
        KingBaseDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, KingBaseDataModelBaseDTO> dataModelDtoMap = kingbaseMsDataModelDTO.getDataModelDtoMap();
        KingBaseDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (KingBaseRelationshipDTO kingbaseRelationshipDTO : relationshipDtoList) {
                List<KingBaseRelationshipFieldDTO> kingbaseRelationshipFieldDTOS;
                String slaveTableId = kingbaseRelationshipDTO.getSlaveTableId();
                String relateModelType = kingbaseRelationshipDTO.getRelateModelType();
                KingBaseDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, kingbaseMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    kingbaseRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(kingbaseRelationshipFieldDTOS = kingbaseRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(KingBaseBackCtx<KingBaseMsDataModel, KingBaseMsDataModelDTO> backCtx, KingBaseDataModelBaseDTO dataModelBaseDTO, KingBaseMsDataModelDTO msDataModelDTO, boolean isMs, KingBaseDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (KingBaseDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", KingBaseConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", KingBaseConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", KingBaseConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/kingbase/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }
}

