<#escape x as x!"">
package ${modelName};

import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowProcessVariableListener;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
<#if imports?? && (imports?size >0)>
<#list imports! as import>
import ${import!};
</#list>
</#if>
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;


@Component(value = "${componentId}ExtListener")
public class ${identityKey?replace("_","")?cap_first?replace("-","")?replace(":","")}ExtListener implements HussarWorkflowProcessVariableListener {

<#--遍历表名，表名+Service组成方法名，引入对应方法依赖-->
<#if tableName?? && tableName != ''>
    @Resource
    private ${tableName?cap_first}ServiceImpl ${tableName?uncap_first}ServiceImpl;
</#if>
<#if kingBaseFlowListenerTables?? && (kingBaseFlowListenerTables?size >0)>
    <#list kingBaseFlowListenerTables! as table>
        <#if table.tableType == "one-to-many">
    @Resource
    private ${table.slaveTable.entityName?cap_first}Service ${table.slaveTable.entityName?uncap_first}Service;
        </#if>
    </#list>
</#if>

    private static Logger logger = LoggerFactory.getLogger(${identityKey?replace("_","")?cap_first?replace("-","")?replace(":","")}ExtListener.class);

    @Override
    public Map${r'<String,'} Object> notify(Map<String, Object> variablesMap) {
        //序列化时防止double类型转换为bigDecimal类型
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        //将所找属性放到map中传递
        Map${r'<String,'} Object> map = new HashMap<>();
        try {
            if (HussarUtils.isEmpty(variablesMap.get("businessId"))){
                logger.info("访问获取业务数据监听器时业务主键为空");
                return map;
            }
        <#--遍历表名，表名作为对象类名，查询方法默认均使用了businessId  select不能放下面的那个循环，因为会增加查询次数-->
            String businessId = String.valueOf(variablesMap.get("businessId"));
<#if tableName?? && tableName != ''>
            //查询所需对象
            Map<String, Object> selectMap = new HashMap<>();
            selectMap.put("${primaryKey}", Long.valueOf(businessId));
            List<${tableName?cap_first}> ${tableName?uncap_first}List = ${tableName?uncap_first}ServiceImpl.getByMap(selectMap);
            if (HussarUtils.isEmpty(${tableName?uncap_first}List)){
                logger.info("访问获取业务数据监听器时业务主键对应数据未找到");
                return map;
            }
            ${tableName?cap_first} ${tableName?uncap_first} = ${tableName?uncap_first}List.get(0);
    <#if securityLevelField??>
            map.put(BpmConstant.ANNOTATION_SECURITY_LEVEL_ATTRIBUTE,"${securityLevelField}");
    </#if>
            // 所有主表表字段整合
            map = JSON.parseObject(JSON.toJSONString(${tableName?uncap_first}, SerializerFeature.WriteMapNullValue), Map.class, disableDecimalFeature);
            //扩展应用中应该不需要
            if (HussarUtils.isNotEmpty(${tableName?uncap_first}.getExpansionMap())){
                map.putAll(${tableName?uncap_first}.getExpansionMap());
            }
</#if>

<#if kingBaseFlowListenerTables?? && (kingBaseFlowListenerTables?size >0)>
        <#--遍历属性名、字段名、表名组 属性名作为key表名作为对象，。get字段名（驼峰）作为方法获取对应值-->
            List<CallActivityInfo> list = new ArrayList<>();
    <#list kingBaseFlowListenerTables! as table>
        <#if table.tableType == "one-to-one">
            //处理一对一子表数据
            if(HussarUtils.copy(${tableName?uncap_first},${table.tableAlias?cap_first}.class) != null) {
                ${table.slaveTable.entityName?cap_first} ${table.tableAlias!} = HussarUtils.copy(${tableName?uncap_first},${table.slaveTable.entityName?cap_first}.class);
                Map<String, Object> variables = new HashMap<>();
                CallActivityInfo callActivityInfo = new CallActivityInfo();
                callActivityInfo.setBusinessId(String.valueOf(${table.tableAlias!}.get${table.slaveTable.keyField.capitalName!}()));
                // 所有一对一子表字段整合
                variables = JSON.parseObject(JSON.toJSONString(${table.tableAlias!}, SerializerFeature.WriteMapNullValue), Map.class, disableDecimalFeature);
                if (HussarUtils.isNotEmpty(${table.tableAlias!}.getExpansionMap())){
                    variables.putAll(${table.tableAlias!}.getExpansionMap());
                }
            <#if table.slaveSecurityLevel??>
                <#list table.slaveSecurityLevel as key, value>
                    <#if key == table.tableAlias>
                Integer securityLevel = HussarUtils.isEmpty(${table.tableAlias!}.get${value?cap_first}()) ? null : Integer.valueOf(${table.tableAlias!}.get${value?cap_first}());
                callActivityInfo.setSecurityLevel(securityLevel);
                    </#if>
                </#list>
            </#if>
                callActivityInfo.setVariable(variables);
                callActivityInfo.setTaskDefinitionKey("${table.taskDefinitionKey!}");
                list.add(callActivityInfo);
            }
        </#if>
        <#if table.tableType == "one-to-many">
            //处理数组子表数据
            List<${table.slaveTable.entityName?cap_first}> ${table.slaveTable.entityName?uncap_first}List =  ${table.slaveTable.entityName?uncap_first}Service.list(new LambdaQueryWrapper<${table.slaveTable.entityName?cap_first}>().eq(${table.slaveTable.entityName?cap_first} :: get${table.slaveTable.foreignKeyField.capitalName!}, businessId));
            if(HussarUtils.isNotEmpty(${table.slaveTable.entityName?uncap_first}List)){
                for(${table.slaveTable.entityName?cap_first} ${table.tableAlias!} : ${table.slaveTable.entityName?uncap_first}List){
                    Map<String, Object> variables = new HashMap<>();
                    CallActivityInfo callActivityInfo = new CallActivityInfo();
                    callActivityInfo.setBusinessId(String.valueOf(${table.tableAlias!}.get${table.slaveTable.keyField.capitalName!}()));
                    variables = JSON.parseObject(JSON.toJSONString(${table.tableAlias!}, SerializerFeature.WriteMapNullValue), Map.class, disableDecimalFeature);
                    if (HussarUtils.isNotEmpty(${table.tableAlias!}.getExpansionMap())){
                        variables.putAll(${table.tableAlias!}.getExpansionMap());
                    }
                    <#if table.slaveSecurityLevel??>
                        <#list table.slaveSecurityLevel as key, value>
                            <#if key == table.tableAlias>
                    Integer securityLevel = HussarUtils.isEmpty(${table.tableAlias!}.get${value?cap_first}()) ? null : Integer.valueOf(${table.tableAlias!}.get${value?cap_first}());
                    callActivityInfo.setSecurityLevel(securityLevel);
                            </#if>
                        </#list>
                    </#if>
                    callActivityInfo.setVariable(variables);
                    callActivityInfo.setTaskDefinitionKey("${table.taskDefinitionKey!}");
                    list.add(callActivityInfo);
                }
            }
        </#if>
    </#list>
            map.put(BpmConstant.CALL_ACTIVITY_INFO, list);
</#if>
    <#if customFlowTableServerModels?? && (customFlowTableServerModels?size >0)>
            //处理自定义变量
        <#list customFlowTableServerModels! as tableServerModel>
            <#if tableServerModel.tableName == "">
            map.put("${tableServerModel.selectName}",null);
            </#if>
        </#list>
</#if>
            logger.info("业务主键{}监听器获取到的业务数据:{}",businessId,JSON.toJSONString(map));

            } catch (Exception e){
                logger.error("访问获取业务数据监听器失败：" + e.getMessage());
                e.printStackTrace();
            }
            return map;
        }
    }
</#escape>
