/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseModelFunction;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.task.KingBaseTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.service.KingBaseWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KingBaseModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"KINGBASE", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            return FileUtil.posixPath((String[])new String[]{apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
        if (ToolUtil.isEmpty((Object)dataModelJson)) {
            return "";
        }
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModelJson.getString("functionType"));
        KingBaseDataModelBase lrDataModelBase = modelFunction.parseDataModel(dataModelJson);
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(KingBaseDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        KingBaseDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (KingBaseDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return new KingBaseWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId, oldVersion, organId, newOrganId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        List<DataModelFieldBase> extSlaveFields;
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        KingBaseDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> kingbaseDataModelFields = new ArrayList<DataModelFieldBase>();
        List<KingBaseDataModelField> fields = dataModelBase.getFields();
        List<Object> slaveTables = new ArrayList();
        KingBaseDataModelBase masterTable = new KingBaseBaseDataModel();
        if (modelFunction instanceof KingBaseFlowMsDataModel) {
            slaveTables = ((KingBaseFlowMsDataModel)dataModelBase).getSlaveTables();
            masterTable = ((KingBaseFlowMsDataModel)dataModelBase).getMasterTable();
        } else if (modelFunction instanceof KingBaseMsDataModel) {
            slaveTables = ((KingBaseMsDataModel)dataModelBase).getSlaveTables();
            masterTable = ((KingBaseMsDataModel)dataModelBase).getMasterTable();
        }
        if (ToolUtil.isNotEmpty(fields)) {
            kingbaseDataModelFields.addAll(fields);
            kingbaseDataModelFields.addAll(this.extFields(modelId, HussarUtils.isEmpty((Object)masterTable.getId()) ? modelId : masterTable.getId()));
            if (HussarUtils.isNotEmpty(slaveTables)) {
                for (KingBaseDataModelBase kingBaseDataModelBase : slaveTables) {
                    kingbaseDataModelFields.addAll(this.extFields(modelId, kingBaseDataModelBase.getId()));
                }
            }
        } else {
            kingbaseDataModelFields.addAll(masterTable.getFields());
            kingbaseDataModelFields.addAll(this.extFields(modelId, masterTable.getId()));
            if (HussarUtils.isNotEmpty(slaveTables)) {
                for (KingBaseDataModelBase kingBaseDataModelBase : slaveTables) {
                    kingbaseDataModelFields.addAll(kingBaseDataModelBase.getFields());
                    kingbaseDataModelFields.addAll(this.extFields(modelId, kingBaseDataModelBase.getId()));
                }
            }
        }
        if (modelFunction instanceof KingBaseTaskDataModel) {
            kingbaseDataModelFields.addAll(((KingBaseTaskDataModel)dataModelBase).getTask().getFields());
        } else if (modelFunction instanceof KingBaseTaskMsDataModel) {
            kingbaseDataModelFields.addAll(((KingBaseTaskMsDataModel)dataModelBase).getTask().getFields());
        }
        if ((modelFunction instanceof KingBaseMsDataModel || modelFunction instanceof KingBaseFlowMsDataModel || modelFunction instanceof KingBaseTaskDataModel) && HussarUtils.isNotEmpty(extSlaveFields = this.extSlaveFields(modelId))) {
            kingbaseDataModelFields.addAll(extSlaveFields);
        }
        return kingbaseDataModelFields;
    }

    private List<DataModelFieldBase> extFields(String sourceId, String modelId) throws LcdpException {
        JSONObject extFieldsJson;
        Object fields;
        Object extFieldsObj;
        JSONObject dataModelBaseExt;
        ArrayList<DataModelFieldBase> extFields = new ArrayList<DataModelFieldBase>();
        if (AppContextUtil.isExtension() && HussarUtils.isNotEmpty((Object)(dataModelBaseExt = DataModelUtil.getDataModelJsonExt((String)sourceId))) && HussarUtils.isNotEmpty((Object)(extFieldsObj = dataModelBaseExt.get((Object)"extFields"))) && HussarUtils.isNotEmpty((Object)(fields = (extFieldsJson = JSONObject.parseObject((String)JSON.toJSONString((Object)extFieldsObj))).get((Object)modelId)))) {
            List dataModelFieldBases = JSONArray.parseArray((String)JSON.toJSONString((Object)fields), DataModelFieldBase.class);
            extFields.addAll(dataModelFieldBases);
        }
        return extFields;
    }

    private List<DataModelFieldBase> extSlaveFields(String sourceId) throws LcdpException {
        JSONArray extSlaveTables;
        ArrayList<DataModelFieldBase> extSlaveFields = new ArrayList<DataModelFieldBase>();
        JSONObject dataModelBaseExt = DataModelUtil.getDataModelJsonExt((String)sourceId);
        if (HussarUtils.isNotEmpty((Object)dataModelBaseExt) && HussarUtils.isNotEmpty((Object)(extSlaveTables = dataModelBaseExt.getJSONArray("slaveTables")))) {
            for (Object extSlaveTable : extSlaveTables) {
                KingBaseDataModelBase kingBaseDataModelBase = (KingBaseDataModelBase)JsonUtil.parse((String)extSlaveTable.toString(), KingBaseBaseDataModel.class);
                if (!HussarUtils.isNotEmpty((Object)kingBaseDataModelBase) || !HussarUtils.isNotEmpty(kingBaseDataModelBase.getFields())) continue;
                extSlaveFields.addAll(kingBaseDataModelBase.getFields());
            }
        }
        return extSlaveFields;
    }

    public void delete(String modelId) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        KingBaseDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return model.getSlaveModelInfo();
    }

    public Map<String, Map<String, String>> getModelAliasName(String modelId) throws LcdpException, IOException, CloneNotSupportedException {
        HashMap<String, Map<String, String>> alias = new HashMap<String, Map<String, String>>();
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        KingBaseDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if ("TASK_MASTER_SLAVE".equals(model.getFunctionType())) {
            KingBaseTaskMsDataModelDTO enclosure = (KingBaseTaskMsDataModelDTO)modelFunction.enclosure().enclosure(model);
            KingBaseDataModelBase kingbaseDataModelBase = enclosure.getDataModelBaseMap().get(modelId);
            alias.put("task", kingbaseDataModelBase.getModelAliasName());
        }
        alias.put("noTask", model.getModelAliasName());
        return alias;
    }

    public Map<String, Object> getSomeModelInfo(JSONObject dataModel) throws LcdpException, IOException, CloneNotSupportedException {
        HashMap<String, Object> some = new HashMap<String, Object>();
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModel.getString("functionType"));
        KingBaseDataModelBase model = modelFunction.parseDataModel(dataModel);
        KingBaseDataModelBaseDTO enclosure = modelFunction.enclosure().enclosure(model);
        if ("TASK_MASTER_SLAVE".equals(model.getFunctionType())) {
            KingBaseDataModelBaseDTO taskDTO = ((KingBaseTaskMsDataModelDTO)enclosure).getDataModelDtoMap().get(dataModel.get((Object)"id"));
            some.put("importInfo", taskDTO.getImportInfo());
            String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)taskDTO.getServiceImplName(), (String)taskDTO.getTablePath().toLowerCase());
            some.put("qualifyBeanName", qualifyBeanName);
            return some;
        }
        if ("TASK".equals(model.getFunctionType())) {
            KingBaseDataModelBaseDTO taskDTO = ((KingBaseTaskDataModelDTO)enclosure).getDataModelDtoMap().get(dataModel.get((Object)"id"));
            some.put("importInfo", taskDTO.getImportInfo());
            String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)taskDTO.getServiceImplName(), (String)taskDTO.getTablePath().toLowerCase());
            some.put("qualifyBeanName", qualifyBeanName);
            return some;
        }
        some.put("importInfo", enclosure.getImportInfo());
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)enclosure.getServiceImplName(), (String)enclosure.getTablePath().toLowerCase());
        some.put("qualifyBeanName", qualifyBeanName);
        return some;
    }
}

