@Override
<#if isPagination?? && isPagination!>
    public ApiResponse<${vo!}> ${name!}(${QueryObj!} ${QueryObj?uncap_first}){
    try {
        Page<${returnValue}> pager = new Page<>(${QueryObj?uncap_first}.getCurrent(), ${QueryObj?uncap_first}.getSize());
        <#--        全局排序-->
        Map<String, String[]> parameterMap = new HashMap<>();
        <#if isSortOverall?? && isSortOverall!>
            String[] orderParameter = new String[1];
            if (${QueryObj?uncap_first}.getOrders() != null) {
                for (OrderItem orderItem : ${QueryObj?uncap_first}.getOrders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                    }else {
                        orderParameter[0] = orderItem.getColumn() + ",desc;";
                    }
                }
            }
            parameterMap.put("orderRule",orderParameter);
        </#if>
        <#--    排序条件，分页排序条件加载page对象中,sortConditionObj排序对象-->
        <#if sortConditionObj??>
            String[] defaultOrderParameter = new String[1];
            String defaultOrder = "";
            <#assign sortFields = sortConditionObj.fields!>
            <#list sortFields as f>
            <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                defaultOrder += "${f.fromModelFieldSort!}" + ",<#if f.sortCondition == "asc">asc<#else>desc</#if>;";
            </#list>
            defaultOrderParameter[0] = defaultOrder;
            parameterMap.put("defaultOrderRule",defaultOrderParameter);
        </#if>
        <#if !isSortOverall?? && !sortConditionObj??>
            QueryWrapper<${returnValue}> queryWrapper = Wrappers.query();
        <#else>
            // 查询条件构造器,将排序条件封装成QueryWrapper
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper<${returnValue}> queryWrapper = singleTableQueryGenerator.initQueryWrapper(new ${returnValue}(), parameterMap);
        </#if>
        if (HussarUtils.isNotEmpty(${QueryObj?uncap_first}.getSuperQueryConditionDto())) {
            // 查询条件构造器,将查询条件封装成QueryWrapper
            List<SuperQueryConditionDto> superQueryConditionDtoList = ${QueryObj?uncap_first}.getSuperQueryConditionDto();
            SuperQueryGenerator<${returnValue}> superQueryGenerator = new SuperQueryGenerator(${returnValue}.class);
            superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
        }
        IPage<${returnValue}> list = this.page(pager, queryWrapper<#if logicallyDelete?? && logicallyDelete!>.lambda().and(wrapper -> wrapper.ne(${returnValue}::get${deleteFlag!}, "1").or().isNull(${returnValue}::get${deleteFlag!}))</#if>);
        ${vo!} ${vo?uncap_first} = new ${vo!}();
        ${vo?uncap_first}.setData(list.getRecords());
        ${vo?uncap_first}.setCount(list.getTotal());
<#else>
    public ApiResponse<${vo!}> ${name!}(${QueryObj!} ${QueryObj?uncap_first}){
    try {
        QueryWrapper<${returnValue}> queryWrapper = Wrappers.query();
        if (HussarUtils.isNotEmpty(${QueryObj?uncap_first}.getSuperQueryConditionDto())) {
            // 查询条件构造器,将查询条件封装成QueryWrapper
            List<SuperQueryConditionDto> superQueryConditionDtoList = ${QueryObj?uncap_first}.getSuperQueryConditionDto();
            SuperQueryGenerator<${returnValue}> superQueryGenerator = new SuperQueryGenerator(${returnValue}.class);
            superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
        }
        ${vo!} ${vo?uncap_first} = new ${vo!}();
        List<${returnValue}> list = this.list(queryWrapper<#if logicallyDelete?? && logicallyDelete!>.lambda().and(wrapper -> wrapper.ne(${returnValue}::get${deleteFlag!}, "1").or().isNull(${returnValue}::get${deleteFlag!}))</#if>);
        ${vo?uncap_first}.setData(list);
        if(HussarUtils.isNotEmpty(list)){
        ${vo?uncap_first}.setCount((long) list.size());
    }
</#if>
        <#--共有部分-->
        ${vo?uncap_first}.setCode(RETURN_CODE);
        return ApiResponse.success(${vo?uncap_first});
    } catch (Exception e) {
        throw new HussarException("表格查询失败:"+e);
        }
    }
