/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.service;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.result.KingBaseCodeResult;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="KINGBASE_RESULT_BEAN")
public class KingBaseCodeMergeServiceImpl
implements CodeMergeService {
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private VersionManageService versionManageService;

    public void writeMergeCode(CodeResult result) throws IOException {
        if (result instanceof KingBaseCodeResult) {
            KingBaseCodeResult codeResult = (KingBaseCodeResult)result;
            String dataId = codeResult.getDataId();
            String lastPublish = ToolUtil.textFomatterByOS((String)codeResult.getLastPublish());
            String newContent = codeResult.getNewCode();
            String filePath = codeResult.getFilePath();
            this.filePublishService.writeStringToFile(lastPublish, filePath);
            this.versionManageService.saveLastPublishCode(dataId, newContent);
            this.versionManageService.saveLastFileCode(dataId, lastPublish);
        }
    }

    public CodeResult parseData(String s) {
        return (CodeResult)JSONObject.parseObject((String)s, KingBaseCodeResult.class);
    }
}

