/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.provider;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseModelFunction;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.service.KingBaseWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KingBaseModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"KINGBASE", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            String tenantCodePrefix = Optional.ofNullable(AppContextUtil.getAppInfo()).map(e -> "/" + e.getTenantId()).orElse("");
            return FileUtil.posixPath((String[])new String[]{tenantCodePrefix, apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        KingBaseDataModelBase lrDataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(KingBaseDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        KingBaseDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (KingBaseDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId) throws LcdpException, IOException, CloneNotSupportedException {
        return new KingBaseWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        KingBaseModelFunction modelFunction = KingBaseModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        KingBaseDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> KingBaseDataModelFields = new ArrayList<DataModelFieldBase>();
        List<KingBaseDataModelField> fields = dataModelBase.getFields();
        if (ToolUtil.isNotEmpty(fields)) {
            KingBaseDataModelFields.addAll(fields);
        } else {
            List<KingBaseDataModelBase> slaveTables = null;
            KingBaseDataModelBase masterTable = new KingBaseBaseDataModel();
            if (modelFunction instanceof KingBaseFlowMsDataModel) {
                slaveTables = ((KingBaseFlowMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((KingBaseFlowMsDataModel)dataModelBase).getMasterTable();
            } else if (modelFunction instanceof KingBaseMsDataModel) {
                slaveTables = ((KingBaseMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((KingBaseMsDataModel)dataModelBase).getMasterTable();
            }
            KingBaseDataModelFields.addAll(masterTable.getFields());
            if (ToolUtil.isNotEmpty(slaveTables)) {
                for (KingBaseDataModelBase slaveTable : slaveTables) {
                    KingBaseDataModelFields.addAll(slaveTable.getFields());
                }
            }
        }
        return KingBaseDataModelFields;
    }

    public void delete(String modelId) throws LcdpException {
    }
}

