/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.flow.masterslaveflow.util;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KingBaseFlowMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx) throws LcdpException {
        KingBaseFlowMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx) throws LcdpException {
        KingBaseFlowMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        KingBaseMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        KingBaseMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        KingBaseDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<KingBaseRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        KingBaseDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (KingBaseRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (KingBaseRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = KingBaseFlowMsUtil.getDelStr(relationshipDtoList, masterDto);
        KingBaseFlowMsUtil.renderTransaction(backCtx, params, currentModelId);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (KingBaseRelationshipDTO KingBaseRelationshipDTO2 : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            KingBaseDataModelBaseDTO kingBaseDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(KingBaseRelationshipDTO2.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, kingBaseDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, kingBaseDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, kingBaseDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        KingBaseMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        KingBaseMsDataModelDTO KingBaseMsDataModelDTO2 = backCtx.getUseDataModelDtoMap().get(modelId);
        List<KingBaseRelationshipDTO> relationshipDtoList = KingBaseMsDataModelDTO2.getRelationshipDtoList();
        KingBaseDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, KingBaseDataModelBaseDTO> dataModelDtoMap = KingBaseMsDataModelDTO2.getDataModelDtoMap();
        KingBaseDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        KingBaseFlowMsUtil.renderTransaction(backCtx, controllerParams, modelId);
        String masterFillCode = KingBaseFlowMsUtil.renderFillCode(mainDataModelDto, KingBaseMsDataModelDTO2);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            for (KingBaseRelationshipDTO relationshipDTO : relationshipDtoList) {
                List<KingBaseRelationshipFieldDTO> KingBaseRelationshipFieldDTOS;
                String slaveTableId = relationshipDTO.getSlaveTableId();
                String relateModelType = relationshipDTO.getRelateModelType();
                KingBaseDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = KingBaseFlowMsUtil.renderFillCode(slaveModelDto, KingBaseMsDataModelDTO2);
                if (slaveFillCode != null) {
                    relationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(KingBaseRelationshipFieldDTOS = relationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private static void renderTransaction(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams, String modelId) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(KingBaseDataModelBaseDTO dataModelBaseDTO, KingBaseMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (KingBaseDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": 
                case "companyId": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/kingbase/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<KingBaseRelationshipDTO> relationshipDtoList, KingBaseDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (KingBaseRelationshipDTO relationtMap : relationshipDtoList) {
            List<KingBaseRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            KingBaseRelationshipFieldDTO KingBaseRelationshipFieldDTO2 = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(KingBaseRelationshipFieldDTO2.getSlaveFieldCap()).append(",idList));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(KingBaseRelationshipFieldDTO2.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                KingBaseRelationshipFieldDTO KingBaseRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(KingBaseRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(KingBaseRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(KingBaseRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(KingBaseFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(KingBaseRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(KingBaseRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(KingBaseFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(KingBaseRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }
}

