/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.KingBaseCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseRender;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseQueryDTO;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseBackRenderUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEFLOW_MASTER_SLAVERENDER")
public class KingBaseFlowMsRender
implements KingBaseRender<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseFlowMsRender.class);
    public static final String RENDER = "KINGBASEFLOW_MASTER_SLAVERENDER";

    @Override
    public List<KingBaseCodeGenerateInfo> renderCode(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<KingBaseCodeGenerateInfo> generateInfos = new ArrayList<KingBaseCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        KingBaseMsDataModelDTO KingBaseMsDataModelDTO2 = backCtx.getUseDataModelDtoMap().get(modelId);
        generateInfos.add(this.genEntityCode(KingBaseMsDataModelDTO2));
        generateInfos.add(this.genVoCode(KingBaseMsDataModelDTO2));
        generateInfos.add(this.genControllerCode(KingBaseMsDataModelDTO2));
        generateInfos.add(this.genServiceCode(KingBaseMsDataModelDTO2));
        generateInfos.add(this.genServiceImplCode(KingBaseMsDataModelDTO2));
        generateInfos.add(this.genMapperCode(KingBaseMsDataModelDTO2));
        generateInfos.add(this.genXmlCode(KingBaseMsDataModelDTO2));
        generateInfos.add(this.genApiCode(KingBaseMsDataModelDTO2, baseFile));
        Map<String, KingBaseQueryDTO> queryDtoMap = KingBaseMsDataModelDTO2.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            for (Map.Entry<String, KingBaseQueryDTO> queryDTOEntry : queryDtoMap.entrySet()) {
                KingBaseQueryDTO queryDTO = queryDTOEntry.getValue();
                KingBaseCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, KingBaseMsDataModelDTO2);
                if (null == queryCodeGenerateInfo) continue;
                generateInfos.add(queryCodeGenerateInfo);
            }
        }
        Map<String, AspectGenerateInfo> aspectGenerateInfoMap = KingBaseMsDataModelDTO2.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(KingBaseMsDataModelDTO2.getAnnotationNames()) && ToolUtil.isNotEmpty(aspectGenerateInfoMap)) {
            for (String annotationName : KingBaseMsDataModelDTO2.getAnnotationNames()) {
                generateInfos.add(this.genAnnotationCode(KingBaseMsDataModelDTO2, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(aspectGenerateInfoMap.get(aspectGenerateInfoMap.keySet().stream().filter(key -> key.equals(annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                generateInfos.add(this.genAspectCode(KingBaseMsDataModelDTO2, annotationName, aspectGenerateInfo));
            }
        }
        Map<String, KingBaseDataModelBase> dataModelBaseMap = KingBaseMsDataModelDTO2.getDataModelBaseMap();
        Map<String, KingBaseDataModelBaseDTO> dataModelDtoMap = KingBaseMsDataModelDTO2.getDataModelDtoMap();
        if (ToolUtil.isNotEmpty(dataModelBaseMap)) {
            for (String key2 : dataModelBaseMap.keySet()) {
                KingBaseBackCtx newBackCtx = new KingBaseBackCtx();
                KingBaseDataModelBase KingBaseDataModelBase2 = dataModelBaseMap.get(key2);
                KingBaseDataModelBaseDTO kingBaseDataModelBaseDTO = dataModelDtoMap.get(key2);
                HashMap<String, KingBaseDataModelBaseDTO> map = new HashMap<String, KingBaseDataModelBaseDTO>();
                map.put(key2, kingBaseDataModelBaseDTO);
                newBackCtx.setBaseFile(baseFile);
                newBackCtx.setUseDataModelBase(KingBaseDataModelBase2);
                newBackCtx.setUseDataModelDtoMap(map);
                List<KingBaseCodeGenerateInfo> childGenerators = KingBaseModelBeanUtil.getFunctionModelVisitorBean(newBackCtx.getUseDataModelBase().getFunctionType()).render().renderCode(newBackCtx);
                if (!ToolUtil.isNotEmpty(childGenerators)) continue;
                for (KingBaseCodeGenerateInfo childGenerator : childGenerators) {
                    if ("controller".equals(childGenerator.getFileType()) || "js".equals(childGenerator.getFileType())) continue;
                    generateInfos.add(childGenerator);
                }
            }
        }
        return generateInfos;
    }

    private KingBaseCodeGenerateInfo genEntityCode(KingBaseMsDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelBaseDTO.getEntityName() + ".java";
        String filePath = "template/kingbase/flowbackcode/mscode/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelBaseDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genVoCode(KingBaseMsDataModelDTO dto) throws LcdpException {
        String modulePath = dto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dto.getVoName() + ".java";
        String filePath = "template/kingbase/flowbackcode/mscode/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dto.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dto.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dto.setVoGeneratorInfo(info);
        } else {
            dto.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dto);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("vo");
        codeGenerateInfo.setFileId(dto.getId());
        codeGenerateInfo.setFileName(dto.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genControllerCode(KingBaseMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getControllerGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(dataModelDto.getImportInfo().get("Entity"));
        imports.add(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.getControllerGenerateInfo().setImports(imports);
        String filePath = "template/kingbase/flowbackcode/mscode/controller.ftl";
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dataModelDto);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genServiceCode(KingBaseMsDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "template/kingbase/flowbackcode/mscode/service.ftl";
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dataModelDto);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genServiceImplCode(KingBaseMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "template/kingbase/flowbackcode/mscode/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dataModelDto);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genMapperCode(KingBaseMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "template/kingbase/flowbackcode/mscode/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dataModelDto);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genXmlCode(KingBaseMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "template/kingbase/flowbackcode/mscode/xml.ftl";
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dataModelDto);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genAnnotationCode(KingBaseMsDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "template/kingbase/flowbackcode/mscode/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genApiCode(KingBaseMsDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = HussarUtils.isNotEmpty((Object)baseFile) && HussarUtils.equals((Object)"MobilePage", (Object)baseFile.getType()) ? "template/preview/api/api-mobile-file.ftl" : "template/preview/api/api-file.ftl";
        String newCode = KingBaseBackRenderUtil.renderTemplate(filePath, dataModelDto);
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private KingBaseCodeGenerateInfo genAspectCode(KingBaseMsDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "template/kingbase/flowbackcode/mscode/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }

    private KingBaseCodeGenerateInfo dynamicModelCode(KingBaseQueryDTO queryDTO, KingBaseDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private KingBaseCodeGenerateInfo genQueryVoCode(KingBaseQueryDTO queryVODto, KingBaseMsDataModelDTO dataModelDto, String modulePath, KingBaseMsDataModel oracleMsDataModel) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryVODto)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("queryDto", queryVODto);
            params.put("model", dataModelDto);
            params.put("modelArrayWithPage", oracleMsDataModel.getOperations().get(0).getReturnValue());
            String writePath = modulePath + File.separator + "qo" + File.separator + this.upperCase(oracleMsDataModel.getOperations().get(0).getReturnValue()) + ".java";
            String filePath = "template/kingbase/flowbackcode/mscode/queryVo.ftl";
            String newCode = RenderUtil.renderTemplate((String)filePath, params);
            KingBaseCodeGenerateInfo codeGenerateInfo = new KingBaseCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(this.upperCase(oracleMsDataModel.getOperations().get(0).getReturnValue()));
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private String upperCase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

