/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseEnclosure;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseRender;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.querycondition.KingBaseQueryCondition;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.querycondition.KingBaseQueryObject;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.sortcondition.KingBaseSortCondition;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseDataModelUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KingBaseMsDataModel
extends KingBaseDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(KingBaseMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<KingBaseQueryCondition> queryConditions;
    private List<KingBaseQueryObject> queryObject;
    private KingBaseDataModelBase masterTable;
    private List<KingBaseDataModelBase> slaveTables;
    private List<KingBaseRelationshipBase> relationships;
    private boolean logicallyDelete;
    private List<KingBaseSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"KINGBASE.MASTER_SLAVE", KingBaseMsDataModel.class);
    }

    @Override
    public KingBaseMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        KingBaseMsDataModel KingBaseMsDataModel2;
        try {
            ArrayList<KingBaseDataModelField> fieldList = new ArrayList<KingBaseDataModelField>();
            KingBaseMsDataModel2 = (KingBaseMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), KingBaseMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                KingBaseDataModelBase master = KingBaseDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(KingBaseMsDataModel2.getName() + "Master");
                KingBaseMsDataModel2.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<KingBaseDataModelBase> slaveTables = new ArrayList<KingBaseDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    KingBaseDataModelBase slaveTable = KingBaseDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (KingBaseRelationshipBase relationship : KingBaseMsDataModel2.getRelationships()) {
                    KingBaseDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(KingBaseBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    KingBaseDataModelField kingBaseDataModelField = new KingBaseDataModelField();
                    kingBaseDataModelField.setId(UUID.randomUUID().toString());
                    kingBaseDataModelField.setName(dataModelBase.getName());
                    kingBaseDataModelField.setComment(dataModelBase.getComment());
                    kingBaseDataModelField.setSourceDataModelId(dataModelBase.getId());
                    kingBaseDataModelField.setDataType("array");
                    fieldList.add(kingBaseDataModelField);
                }
                KingBaseMsDataModel2.setSlaveTables(slaveTables);
            }
            KingBaseMsDataModel2.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return KingBaseMsDataModel2;
    }

    @Override
    public KingBaseEnclosure<KingBaseDataModelBase> enclosure() throws LcdpException {
        return KingBaseModelBeanUtil.getEnclosureBean("KINGBASE", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public KingBaseRender<KingBaseDataModelBase, KingBaseDataModelBaseDTO> render() throws LcdpException {
        return KingBaseModelBeanUtil.getRenderBean("KINGBASE", FUNCTION_TYPE, "RENDER");
    }

    public KingBaseDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(KingBaseDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<KingBaseDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<KingBaseDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<KingBaseRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<KingBaseRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<KingBaseQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<KingBaseQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<KingBaseQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<KingBaseQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<KingBaseSortCondition> getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(List<KingBaseSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public KingBaseQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (KingBaseQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public KingBaseSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (KingBaseSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                KingBaseRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<KingBaseDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> tableContrastModel(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<KingBaseDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> modelContrastTable(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<KingBaseDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws Exception {
        String sql = this.masterTable.copyTableByModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            sql = sql + this.slaveTables.get(i).copyTableByModel(fieldsContrastParam);
        }
        return sql;
    }

    public KingBaseDataModelField getDeleteFlag() {
        return this.getMasterTable().getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public KingBaseDataModelField getPrimaryKey() {
        return this.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }
}

