/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.base;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseOperationVisitor;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.function.render.KingBaseBaseRender;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="KINGBASEBASEFlagDeleteBatch")
public class KingBaseFlagDeleteVisitor
implements KingBaseOperationVisitor<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KingBaseFlagDeleteVisitor.class);
    public static final String OPERATION_NAME = "KINGBASEBASEFlagDeleteBatch";

    @Override
    public void visit(KingBaseBackCtx<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation) throws LcdpException {
        LOGGER.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        KingBaseBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        KingBaseBaseDataModel KingBaseBaseDataModel2 = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = KingBaseBaseDataModel2.getLogicallyDelete();
        Map<String, Object> flagDeleteParams = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        KingBaseDataModelFieldDto keyFieldDto = dataModelBaseDTO.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            LOGGER.error("\u6a21\u578b\u672a\u8bbe\u7f6e\u4e3b\u952e");
            return;
        }
        String controllerPath = "template/kingbase/backcode/flagdelete/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, flagDeleteParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/kingbase/backcode/flagdelete/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, flagDeleteParams));
        String serviceImplPath = "template/kingbase/backcode/flagdelete/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, flagDeleteParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        if (isLogicallyDelete) {
            flagDeleteParams.put("deleteFlag", KingBaseBaseDataModel2.getDeleteFlag().getSourceFieldName());
            flagDeleteParams.put("primaryKey", KingBaseBaseDataModel2.getPrimaryKey().getSourceFieldName());
            backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
            String mapperPath = "template/kingbase/backcode/flagdelete/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, flagDeleteParams));
            String xmlPath = "template/kingbase/backcode/flagdelete/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, flagDeleteParams));
        }
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isLogicallyDelete);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5220\u9664");
        backCtx.addApi(modelId, KingBaseBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(KingBaseBackCtx<KingBaseBaseDataModel, KingBaseBaseDataModelDTO> backCtx, String modelId, KingBaseBaseDataModelDTO dataModelBaseDTO, Boolean isLogicallyDelete) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "java.util.Arrays");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        if (isLogicallyDelete.booleanValue()) {
            backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        } else {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
    }

    private Map<String, Object> initParams(KingBaseDataModelOperation dataModelOperation, KingBaseBaseDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) throws LcdpException {
        Map<String, Object> flagDeleteParams = dataModelOperation.getParams();
        flagDeleteParams.put("table", dataModelBaseDTO);
        flagDeleteParams.put("returnValue", dataModelBaseDTO.getEntityName());
        flagDeleteParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        flagDeleteParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u6279\u91cf\u5220\u9664");
            flagDeleteParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return flagDeleteParams;
    }
}

