/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.element.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseEnclosure;
import com.jxdinfo.hussar.formdesign.kingbase.function.KingBaseRender;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseDataModelUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.KingBaseModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KingBaseFlowMsDataModel
extends KingBaseMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(KingBaseFlowMsDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<KingBaseDataModelField> flowFields;

    public List<KingBaseDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<KingBaseDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"KINGBASE.FLOW_MASTER_SLAVE", KingBaseFlowMsDataModel.class);
    }

    @Override
    public KingBaseFlowMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        KingBaseFlowMsDataModel KingBaseFlowMsDataModel2;
        try {
            ArrayList<KingBaseDataModelField> fieldList = new ArrayList<KingBaseDataModelField>();
            KingBaseFlowMsDataModel2 = (KingBaseFlowMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), KingBaseFlowMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                KingBaseDataModelBase master = KingBaseDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(KingBaseFlowMsDataModel2.getName() + "Master");
                KingBaseFlowMsDataModel2.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<KingBaseDataModelBase> slaveTables = new ArrayList<KingBaseDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    KingBaseDataModelBase slaveTable = KingBaseDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (KingBaseRelationshipBase relationship : KingBaseFlowMsDataModel2.getRelationships()) {
                    KingBaseDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(KingBaseBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    KingBaseDataModelField kingBaseDataModelField = new KingBaseDataModelField();
                    kingBaseDataModelField.setId(UUID.randomUUID().toString());
                    kingBaseDataModelField.setName(dataModelBase.getName());
                    kingBaseDataModelField.setComment(dataModelBase.getComment());
                    kingBaseDataModelField.setSourceDataModelId(dataModelBase.getId());
                    kingBaseDataModelField.setDataType("array");
                    fieldList.add(kingBaseDataModelField);
                }
                KingBaseFlowMsDataModel2.setSlaveTables(slaveTables);
            }
            KingBaseFlowMsDataModel2.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return KingBaseFlowMsDataModel2;
    }

    @Override
    public KingBaseEnclosure<KingBaseDataModelBase> enclosure() throws LcdpException {
        return KingBaseModelBeanUtil.getEnclosureBean("KINGBASE", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public KingBaseRender<KingBaseDataModelBase, KingBaseDataModelBaseDTO> render() throws LcdpException {
        return KingBaseModelBeanUtil.getRenderBean("KINGBASE", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<KingBaseDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<KingBaseDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<KingBaseDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable((FieldsContrastParam<KingBaseDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<KingBaseDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws Exception {
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<KingBaseDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTableByModel(fieldsContrastParam);
    }
}

