/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgOperationVisitor;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.task.HgTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.task.HgTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.function.visitor.task.masterslavetask.HgMsTaskAsyncVerifyVisitor;
import com.jxdinfo.hussar.formdesign.hg.util.HgBackRenderUtil;
import com.jxdinfo.hussar.formdesign.hg.util.SqlReturnUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HIGHGOTASK_MASTER_SLAVEUniqueVerify")
public class HgMsTaskUniqueVerifyVisitor
implements HgOperationVisitor<HgTaskMsDataModel, HgTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(HgMsTaskAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "HIGHGOTASK_MASTER_SLAVEUniqueVerify";

    @Override
    public void visit(HgBackCtx<HgTaskMsDataModel, HgTaskMsDataModelDTO> taskBackCtx, HgDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        HgFlowMsDataModelDTO dataModelBaseDTO = (HgFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        HgFlowMsDataModel useDataModelBase = (HgFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx = new HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(useDataModelBase);
        HashMap<String, HgFlowMsDataModelDTO> map = new HashMap<String, HgFlowMsDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        controllerParams.put("getPrimaryMethod", String.format("%s%s", "get", dataModelBaseDTO.getPrimaryKeyFirstToUpper()));
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", dataModelBaseDTO.getComment() + "\u552f\u4e00\u6027\u6821\u9a8c");
        }
        controllerParams.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        controllerParams.put("entityName", dataModelBaseDTO.getEntityName());
        controllerParams.put("mapperEnName", dataModelBaseDTO.getMapperEnName());
        controllerParams.put("table", dataModelBaseDTO);
        List<HgDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            HgDataModelField logicallyField = useDataModelBase.getDeleteFlag();
            for (HgDataModelFieldDto field : fields) {
                if (!field.getId().equals(logicallyField.getId())) continue;
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + useDataModelBase.getDeleteFlag().getSourceFieldName();
                controllerParams.put("logicallyFlag", logicallyFlag);
                break;
            }
        }
        SqlReturnUtil.renderAlias((HgMsDataModel)backCtx.getUseDataModelBase(), ((HgFlowMsDataModel)backCtx.getUseDataModelBase()).getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/hg/masterslavebackcode/uniqueverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/hg/masterslavebackcode/uniqueverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/hg/masterslavebackcode/uniqueverify/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        String finalReturn = SqlReturnUtil.renderReturn((HgMsDataModel)backCtx.getUseDataModelBase(), ((HgFlowMsDataModel)backCtx.getUseDataModelBase()).getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/hg/masterslavebackcode/uniqueverify/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/hg/masterslavebackcode/uniqueverify/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation((HgMsDataModel)backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u552f\u4e00\u6027\u6821\u9a8c");
        backCtx.addApi(modelId, HgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, String modelId, HgMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "java.util.List");
    }
}

