/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.element.customview;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.hg.function.HgEnclosure;
import com.jxdinfo.hussar.formdesign.hg.function.HgRender;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.querycondition.HgQueryCondition;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.querycondition.HgQueryObject;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.sortcondition.HgSortCondition;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.sortcondition.HgSortConditionField;
import com.jxdinfo.hussar.formdesign.hg.util.HgDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HgCustomViewModel
extends HgDataModelBase {
    private static final Logger logger = LoggerFactory.getLogger(HgDataModelBase.class);
    public static final String FUNCTION_TYPE = "CUSTOM_VIEW";
    private String viewSql;
    public static final Logger LOGGER = LoggerFactory.getLogger(HgBaseDataModel.class);
    private String sourceDataModelName;
    private List<HgQueryCondition> queryConditions;
    private List<HgQueryObject> queryObject;
    private List<HgSortCondition> sortCondition;
    private List<HgDataModelField> addFields;
    private List<HgDataModelField> delFields;
    private List<HgDataModelField> editFields;

    public String getViewSql() {
        return this.viewSql;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
    }

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HIGHGO.CUSTOM_VIEW", HgCustomViewModel.class);
    }

    @Override
    public HgCustomViewModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HgCustomViewModel customSqlModel;
        try {
            customSqlModel = (HgCustomViewModel)JSONObject.parseObject((String)jsonObject.toString(), HgCustomViewModel.class);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return customSqlModel;
    }

    public HgEnclosure enclosure() throws LcdpException {
        return null;
    }

    public HgRender render() throws LcdpException {
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<HgQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<HgQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<HgQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<HgQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<HgSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (HgSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (HgSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = HgDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<HgSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<HgDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<HgDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<HgDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<HgDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<HgDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<HgDataModelField> editFields) {
        this.editFields = editFields;
    }

    @Override
    public HgQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (HgQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new HgQueryCondition();
    }

    @Override
    public HgSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (HgSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new HgSortCondition();
    }
}

