/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.back.common.constant.QueryType;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.task.HgTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.task.HgTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.hgQueryDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.querycondition.HgQueryCondition;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.querycondition.HgQueryConditionField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.sortcondition.HgSortCondition;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.sortcondition.HgSortConditionField;
import com.jxdinfo.hussar.formdesign.hg.function.render.HgBaseRender;
import com.jxdinfo.hussar.formdesign.hg.util.HgDataModelUtil;
import com.jxdinfo.hussar.formdesign.hg.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.hg.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.hg.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HgMsTaskTableQueryFlowTotals {
    private static final Logger logger = LoggerFactory.getLogger(HgMsTaskTableQueryFlowTotals.class);
    public static final String TASK_PAGE_VO = "TaskPageVO";

    public static void visit(HgBackCtx<HgTaskMsDataModel, HgTaskMsDataModelDTO> backCtx, HgDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        HgTaskMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = HgMsTaskTableQueryFlowTotals.initParams(dataModelOperation, dataModelBaseDTO);
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        boolean isSortCondition = HgMsTaskTableQueryFlowTotals.renderSort(backCtx, dataModelOperation, modelId, controllerParams, backCtx.getUseDataModelBase(), isPagination);
        boolean isSelectCondition = HgMsTaskTableQueryFlowTotals.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        controllerParams.put("isSortOverall", isSortOverall);
        HgMsTaskTableQueryFlowTotals.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/hg/taskbackcode/masterslavetaskbackcode/query/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/hg/taskbackcode/masterslavetaskbackcode/query/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/hg/taskbackcode/masterslavetaskbackcode/query/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        List<HgDataModelField> dataModelFieldBases = backCtx.getUseDataModelBase().getFields();
        String finalReturn = SqlReturnUtil.renderReturn(dataModelFieldBases, backCtx.getUseDataModelBase().getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/hg/taskbackcode/masterslavetaskbackcode/query/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/hg/taskbackcode/masterslavetaskbackcode/query/xml.ftl";
        String finalRelation = SqlReturnUtil.renderFlowTotalsRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        HgMsTaskTableQueryFlowTotals.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSelectCondition, isSortCondition, isSortOverall);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, HgBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static void renderImport(HgBackCtx<HgTaskMsDataModel, HgTaskMsDataModelDTO> backCtx, String modelId, HgTaskMsDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSelectCondition, boolean isSortCondition, boolean isSortOverall) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
        } else if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isSortCondition) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private static Map<String, Object> initParams(HgDataModelOperation dataModelOperation, HgTaskMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        String queryType = (String)dataModelOperation.getParams().get("queryType");
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : "") + QueryType.getLabel((String)queryType));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : "") + QueryType.getLabel((String)queryType));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private static boolean renderSelect(HgBackCtx<HgTaskMsDataModel, HgTaskMsDataModelDTO> backCtx, HgDataModelOperation dataModelOperation, String modelId, HgTaskMsDataModelDTO dataModelBaseDTO, Map<String, Object> templateParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        Map<String, String> aliasMap = backCtx.getUseDataModelBase().getModelAliasName();
        String inValuesSql = HgMsTaskTableQueryFlowTotals.getInValuesSql(backCtx.getUseDataModelBase(), dataModelOperation, aliasMap, selectConditionName);
        HgMsDataModel msDataModel = backCtx.getUseDataModelBase();
        HgDataModelField deleteField = msDataModel.getDeleteFlag();
        boolean isLogicallyDelete = msDataModel.isLogicallyDelete();
        if (!StringUtil.isNotBlank((CharSequence)selectConditionName)) {
            if (isLogicallyDelete) {
                templateParams.put("addLogicallyCondition", true);
                String logicallyFlag = msDataModel.getModelAliasName().get(msDataModel.getMasterTable().getId()) + "." + deleteField.getSourceFieldName();
                templateParams.put("logicallyFlag", logicallyFlag);
            }
            return false;
        }
        HgQueryCondition queryCondition = backCtx.getUseDataModelBase().getQuConBaseByName(selectConditionName);
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (HgQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<HgDataModelField> fields = backCtx.getUseDataModelBase().getFields();
            boolean isStringType = true;
            for (HgDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        templateParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(HgQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        templateParams.put("isSelectCondition", true);
        DataSet dataSet = backCtx.getUseDataModelBase().getDataSetById(queryCondition.getFromDataSet());
        if (isLogicallyDelete) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, deleteField.getName(), msDataModel.getMasterTable().getId());
        }
        hgQueryDTO queryDTO = HgDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), inValuesSql, dataModelBaseDTO, aliasMap, backCtx.getUseDataModelBase(), deleteField == null ? "" : deleteField.getSourceFieldName());
        if (isLogicallyDelete) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        templateParams.put("whereSql", finalWhereSql);
        templateParams.put("QueryObj", queryDTO.getEntityName());
        templateParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private static boolean renderSort(HgBackCtx<HgTaskMsDataModel, HgTaskMsDataModelDTO> backCtx, HgDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, HgTaskMsDataModel useDataModelBase, boolean isPagination) throws LcdpException {
        HgSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && HussarUtils.isNotEmpty((Object)(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName))) && Optional.of(sortCondition).map(HgSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<HgSortConditionField> sortConditionFields;
            List<HgSortConditionField> fields = sortCondition.getFields();
            block0: for (HgSortConditionField hgSortConditionField : fields) {
                String fromModelFieldIdSort = hgSortConditionField.getFromModelFieldIdSort();
                List<HgDataModelField> fromModelFieldSort = useDataModelBase.getFields();
                for (HgDataModelField hgDataModelField : fromModelFieldSort) {
                    if (!hgDataModelField.getId().equals(fromModelFieldIdSort)) continue;
                    hgSortConditionField.setFromModelFieldSort(hgDataModelField.getName());
                    continue block0;
                }
            }
            if (!isPagination) {
                sortConditionFields = sortCondition.getFields();
                for (HgSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
                }
            } else {
                sortConditionFields = sortCondition.getFields();
                for (HgSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private static void renderPageVo(HgBackCtx<HgTaskMsDataModel, HgTaskMsDataModelDTO> backCtx, String modelId, HgTaskMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        HgDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private static String getInValuesSql(HgMsDataModel useDataModelBase, HgDataModelOperation dataModelOperation, Map<String, String> aliasMap, String selectConditionName) {
        HgDataModelField realFieldBase;
        String template = "<if test=\"inValues != null and inValues.size > 0\">\n ${T_ALIAS}.${REAL_FIELD} in\n    <foreach collection=\"inValues\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>\n";
        String entityAttr = (String)dataModelOperation.getParams().get("relateField");
        if (ToolUtil.isNotEmpty((Object)entityAttr) && ToolUtil.isNotEmpty((Object)((Object)(realFieldBase = useDataModelBase.getFields().stream().filter(field -> entityAttr.equals(field.getName())).findAny().orElseGet(HgDataModelField::new))))) {
            String alias = aliasMap.get(realFieldBase.getSourceDataModelId());
            String sourceFieldName = realFieldBase.getSourceFieldName();
            if (useDataModelBase.isLogicallyDelete() && !StringUtil.isNotBlank((CharSequence)selectConditionName)) {
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + useDataModelBase.getDeleteFlag().getSourceFieldName();
                template = template + "AND (" + logicallyFlag + " != '1' or " + logicallyFlag + " IS NULL)";
            }
            return template.replace("${T_ALIAS}", alias).replace("${REAL_FIELD}", sourceFieldName);
        }
        return "";
    }

    private void renderTaskPageVo(HgBackCtx<HgTaskMsDataModel, HgTaskMsDataModelDTO> backCtx, String modelId, HgTaskMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        hgQueryDTO queryDTO = new hgQueryDTO();
        queryDTO.setFtlPath("template/hg/taskbackcode/mscode/taskPage.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + TASK_PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + TASK_PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + TASK_PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

