/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgOperationVisitor;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.relationship.HgRelationshipDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.relationship.HgRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.hgQueryDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.function.visitor.constant.HgConstUtil;
import com.jxdinfo.hussar.formdesign.hg.function.visitor.masterslave.util.HgMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.hg.util.HgBackRenderUtil;
import com.jxdinfo.hussar.formdesign.hg.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HIGHGOFLOW_MASTER_SLAVEFormSave")
public class HgMsFlolwFormSaveVisitor
implements HgOperationVisitor<HgFlowMsDataModel, HgFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(HgMsFlolwFormSaveVisitor.class);
    public static final String OPERATION_NAME = "HIGHGOFLOW_MASTER_SLAVEFormSave";

    @Override
    public void visit(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, HgDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        HgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        HgMsDataModelDTO hgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = hgMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, Object> controllerParams = operation.getParams();
        HgDataModelFieldDto keyField = hgMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map slaveTablePlusSave = (Map)operation.getParams().get("slaveTablePlusSave");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (HgDataModelBase hgDataModelBase : dataModelBase.getSlaveTables()) {
            HgDataModelBaseDTO hgDataModelBaseDTO = hgMsDataModelDTO.getDataModelDtoMap().get(hgDataModelBase.getId());
            String slaveModelName = hgDataModelBase.getName();
            for (HgDataModelFieldDto hgDataModelFieldDto : hgDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(hgDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, hgDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        boolean plusFlag = false;
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        if (plusFlag) {
            for (HgRelationshipDTO relationshipDTO : hgMsDataModelDTO.getRelationshipDtoList()) {
                if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
                slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
            }
            for (HgDataModelBase modelBase : dataModelBase.getSlaveTables()) {
                isLogicallyDelete.put(modelBase.getId(), ((HgBaseDataModel)modelBase).getLogicallyDelete());
                HgDataModelBaseDTO hgDataModelBaseDTO = hgMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
                String slaveModelName = modelBase.getName();
                capitalNameList.put(slaveModelName, HgMasterSlaveUtil.getCapitalName(slaveModelName));
                for (HgDataModelField hgDataModelField : modelBase.getFields()) {
                    if (!"delDefFlag".equals(hgDataModelField.getUsage())) continue;
                    logicallyDelField.put(slaveModelName, hgDataModelField.getName());
                }
                for (HgDataModelFieldDto hgDataModelFieldDto : hgDataModelBaseDTO.getFields()) {
                    if ("primary".equals(hgDataModelFieldDto.getFill())) {
                        primaryKeys.put(slaveModelName, hgDataModelFieldDto.getCapitalName());
                    }
                    if (!"foreign".equals(hgDataModelFieldDto.getFill())) continue;
                    foreignKeys.put(slaveModelName, hgDataModelFieldDto.getCapitalName());
                }
            }
            this.addFormPlusSaveDto(dataModelBase, hgMsDataModelDTO, backCtx, slaveTablePlusSave);
        }
        controllerParams.put("table", hgMsDataModelDTO);
        controllerParams.put("returnValue", hgMsDataModelDTO.getEntityName());
        if (plusFlag) {
            controllerParams.put("returnValue", hgMsDataModelDTO.getEntityName() + "IncrementDTO");
        }
        controllerParams.put("url", url);
        HgDataModelBaseDTO hgDataModelBaseDTO = hgMsDataModelDTO.getDataModelDtoMap().get(dataModelBase.getMasterTable().getId());
        controllerParams.put("masterTable", hgDataModelBaseDTO);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(hgMsDataModelDTO.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/hg/flowbackcode/masterslaveflowbackcode/formsave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, hgMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, hgMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, hgMsDataModelDTO.getServiceName());
        String servicePath = "template/hg/flowbackcode/masterslaveflowbackcode/formsave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        this.masterSlaveCode(backCtx, controllerParams);
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        if (plusFlag) {
            controllerParams.put("primaryKeys", primaryKeys);
            controllerParams.put("foreignKeys", foreignKeys);
            controllerParams.put("slaveTable", HgMasterSlaveUtil.ofSlaveParam(dataModelBase, hgMsDataModelDTO));
            controllerParams.put("isPlusSave", true);
            controllerParams.put("isLogicallyDelete", isLogicallyDelete);
            controllerParams.put("logicallyDelField", logicallyDelField);
            controllerParams.put("capitalNameList", capitalNameList);
        }
        String serviceImplPath = "template/hg/flowbackcode/masterslaveflowbackcode/formsave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, HgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void masterSlaveCode(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        HgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        HgMsDataModelDTO hgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<HgRelationshipDTO> relationshipDtoList = hgMsDataModelDTO.getRelationshipDtoList();
        HgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, HgDataModelBaseDTO> dataModelDtoMap = hgMsDataModelDTO.getDataModelDtoMap();
        HgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, hgMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (HgRelationshipDTO hgRelationshipDTO : relationshipDtoList) {
                List<HgRelationshipFieldDTO> hgRelationshipFieldDTOS;
                String slaveTableId = hgRelationshipDTO.getSlaveTableId();
                String relateModelType = hgRelationshipDTO.getRelateModelType();
                HgDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, hgMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    hgRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(hgRelationshipFieldDTOS = hgRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private void addFormPlusSaveDto(HgMsDataModel dataModelBase, HgMsDataModelDTO dataModelDTO, HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        hgQueryDTO queryDTO = new hgQueryDTO();
        String modelId = dataModelBase.getId();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/hg/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", HgMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", dataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(dataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(dataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = dataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        dataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private String renderFillCode(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, HgDataModelBaseDTO dataModelBaseDTO, HgMsDataModelDTO msDataModelDTO, boolean isMs, HgDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (HgDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", HgConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", HgConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", HgConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/hg/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }
}

