/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.visitor.flow.masterslaveflow.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.relationship.HgRelationshipDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.relationship.HgRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.hgQueryDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.function.visitor.masterslave.util.HgMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.hg.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HgFlowMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";
    private static final String FLOW_INCREMENT_NAME = "FlowIncrementDTO";

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx) throws LcdpException {
        HgFlowMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx) throws LcdpException {
        HgFlowMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        HgMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HgMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        HgDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<HgRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        HgDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (HgRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (HgRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = HgFlowMsUtil.getDelStr(relationshipDtoList, masterDto);
        HgFlowMsUtil.renderTransaction(backCtx, params, currentModelId);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (HgRelationshipDTO hgRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            HgDataModelBaseDTO hgDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(hgRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, hgDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, hgDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, hgDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        HgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        HgMsDataModelDTO hgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<HgRelationshipDTO> relationshipDtoList = hgMsDataModelDTO.getRelationshipDtoList();
        HgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, HgDataModelBaseDTO> dataModelDtoMap = hgMsDataModelDTO.getDataModelDtoMap();
        HgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        HgFlowMsUtil.renderTransaction(backCtx, controllerParams, modelId);
        String masterFillCode = HgFlowMsUtil.renderFillCode(backCtx, mainDataModelDto, hgMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (HgRelationshipDTO relationshipDTO : relationshipDtoList) {
                List<HgRelationshipFieldDTO> hgRelationshipFieldDTOS;
                String slaveTableId = relationshipDTO.getSlaveTableId();
                String relateModelType = relationshipDTO.getRelateModelType();
                HgDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = HgFlowMsUtil.renderFillCode(backCtx, slaveModelDto, hgMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    relationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(hgRelationshipFieldDTOS = relationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams, String modelId) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, HgDataModelBaseDTO dataModelBaseDTO, HgMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (HgDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/hg/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<HgRelationshipDTO> relationshipDtoList, HgDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (HgRelationshipDTO relationtMap : relationshipDtoList) {
            List<HgRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            HgRelationshipFieldDTO hgRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                Optional<HgDataModelFieldDto> relationTag;
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(hgRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
                List<HgDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    HgDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(hgRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                Optional<HgDataModelFieldDto> relationTag;
                HgRelationshipFieldDTO hgRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(hgRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(hgRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(hgRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(HgFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(hgRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(hgRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(HgFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(hgRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                List<HgDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    HgDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void generateIncrementDTO(HgMsDataModelDTO hgFlowDataModelDTO, HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, HgDataModelOperation dataModelOperation) {
        Map<String, Object> params = dataModelOperation.getParams();
        Map slaveTablePlusSave = (Map)params.get("slaveTablePlusSave");
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        HgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        for (HgDataModelBase hgDataModelBase : dataModelBase.getSlaveTables()) {
            String slaveModelName = hgDataModelBase.getName();
            HgDataModelBaseDTO hgDataModelBaseDTO = hgFlowDataModelDTO.getDataModelDtoMap().get(hgDataModelBase.getId());
            for (HgDataModelFieldDto field : hgDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(field.getFill())) continue;
                relationTagKeys.put(slaveModelName, field.getCapitalName());
            }
        }
        params.put("relationTagKeys", relationTagKeys);
        boolean plusFlag = false;
        if (HussarUtils.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        params.put("ifPlusSave", plusFlag);
        if (!plusFlag) {
            return;
        }
        for (HgRelationshipDTO relationshipDTO : hgFlowDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        HgFlowMsUtil.addIncrementTable(hgFlowDataModelDTO, slaveTablePlusSave, dataModelBase);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        for (HgDataModelBase modelBase : dataModelBase.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((HgBaseDataModel)modelBase).getLogicallyDelete());
            HgDataModelBaseDTO hgDataModelBaseDTO = hgFlowDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, HgMasterSlaveUtil.getCapitalName(slaveModelName));
            for (HgDataModelField hgDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(hgDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, hgDataModelField.getName());
                break;
            }
            for (HgDataModelFieldDto hgDataModelFieldDto : hgDataModelBaseDTO.getFields()) {
                if ("primary".equals(hgDataModelFieldDto.getFill())) {
                    hashMap.put(slaveModelName, hgDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(hgDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, hgDataModelFieldDto.getCapitalName());
            }
        }
        params.put("primaryKeys", hashMap);
        params.put("foreignKeys", foreignKeys);
        params.put("slaveTablePlusSave", slaveTablePlusSave);
        params.put("slaveTable", HgMasterSlaveUtil.ofSlaveParam(dataModelBase, hgFlowDataModelDTO));
        params.put("isLogicallyDelete", isLogicallyDelete);
        params.put("logicallyDelField", logicallyDelField);
        params.put("capitalNameList", capitalNameList);
        String modelId = backCtx.getUseDataModelBase().getId();
        if (HussarUtils.isEmpty((Object)hgFlowDataModelDTO.getQueryDtoMap().get(hgFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME))) {
            hgQueryDTO oldDTO = hgFlowDataModelDTO.getQueryDtoMap().get(hgFlowDataModelDTO.getName());
            hgQueryDTO hgQueryDTO2 = (hgQueryDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDTO), hgQueryDTO.class);
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("queryDto", hgQueryDTO2);
            HashMap<String, Boolean> table = new HashMap<String, Boolean>();
            table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
            newParams.put("table", table);
            hgQueryDTO2.setParams(newParams);
            String string = hgFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME;
            String plusTableName = hgFlowDataModelDTO.getEntityName() + "IncrementTable";
            for (HgQueryFieldDTO dto : hgQueryDTO2.getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                dto.getDbColumnType().setType(plusTableName);
                dto.getDbColumnType().setImportT(hgQueryDTO2.getPackageInfo() + "." + plusTableName);
                params.put("incrementTable", dto.getDbColumnType());
                backCtx.addServiceImplImport(modelId, dto.getDbColumnType().getImportT());
                break;
            }
            hgQueryDTO2.setName(hgQueryDTO2.getName() + FLOW_INCREMENT_NAME);
            hgQueryDTO2.setEntityName(string);
            hgQueryDTO2.setImportInfo(hgQueryDTO2.getPackageInfo() + "." + string);
            hgQueryDTO2.setWriteFilePath(FileUtil.systemPath((String[])new String[]{hgFlowDataModelDTO.getTablePath(), "dto", string + ".java"}));
            hgFlowDataModelDTO.getQueryDtoMap().put(hgQueryDTO2.getName(), hgQueryDTO2);
            params.put("parameter", string);
            backCtx.addControllerImport(modelId, hgQueryDTO2.getImportInfo());
            backCtx.addServiceImport(modelId, hgQueryDTO2.getImportInfo());
            backCtx.addServiceImplImport(modelId, hgQueryDTO2.getImportInfo());
        } else {
            for (HgQueryFieldDTO dto : hgFlowDataModelDTO.getQueryDtoMap().get(hgFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME).getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                params.put("incrementTable", dto.getDbColumnType());
                break;
            }
            params.put("parameter", hgFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME);
        }
    }

    private static void addIncrementTable(HgMsDataModelDTO dataModelBaseDTO, Map<String, Boolean> slaveTablePlusSave, HgMsDataModel dataModelBase) {
        hgQueryDTO queryDTO = new hgQueryDTO();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/hg/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelBaseDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", HgMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setName(dataModelBaseDTO.getName() + "IncrementTable");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "IncrementTable");
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }
}

