/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.visitor.base;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgOperationVisitor;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.function.render.HgBaseRender;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HIGHGOBASEFlagDeleteBatch")
public class HgFlagDeleteVisitor
implements HgOperationVisitor<HgBaseDataModel, HgBaseDataModelDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HgFlagDeleteVisitor.class);
    public static final String OPERATION_NAME = "HIGHGOBASEFlagDeleteBatch";

    @Override
    public void visit(HgBackCtx<HgBaseDataModel, HgBaseDataModelDTO> backCtx, HgDataModelOperation dataModelOperation) throws LcdpException {
        LOGGER.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        HgBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        HgBaseDataModel hgBaseDataModel = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = hgBaseDataModel.getLogicallyDelete();
        Map<String, Object> flagDeleteParams = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        HgDataModelFieldDto keyFieldDto = dataModelBaseDTO.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            LOGGER.error("\u6a21\u578b\u672a\u8bbe\u7f6e\u4e3b\u952e");
            return;
        }
        String controllerPath = "template/hg/backcode/flagdelete/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, flagDeleteParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/hg/backcode/flagdelete/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, flagDeleteParams));
        String serviceImplPath = "template/hg/backcode/flagdelete/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, flagDeleteParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        if (isLogicallyDelete) {
            flagDeleteParams.put("deleteFlag", hgBaseDataModel.getDeleteFlag().getSourceFieldName());
            if (ToolUtil.isNotEmpty((Object)((Object)hgBaseDataModel.getUpdateTime()))) {
                flagDeleteParams.put("updateTime", hgBaseDataModel.getUpdateTime().getSourceFieldName());
            }
            flagDeleteParams.put("primaryKey", hgBaseDataModel.getPrimaryKey().getSourceFieldName());
            backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
            String mapperPath = "template/hg/backcode/flagdelete/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, flagDeleteParams));
            String xmlPath = "template/hg/backcode/flagdelete/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, flagDeleteParams));
        }
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isLogicallyDelete);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5220\u9664");
        backCtx.addApi(modelId, HgBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(HgBackCtx<HgBaseDataModel, HgBaseDataModelDTO> backCtx, String modelId, HgBaseDataModelDTO dataModelBaseDTO, Boolean isLogicallyDelete) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "java.util.Arrays");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "org.springframework.beans.factory.annotation.Autowired");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        if (isLogicallyDelete.booleanValue()) {
            backCtx.addServiceImplImport(modelId, "java.time.LocalDateTime");
            backCtx.addMapperImport(modelId, "java.time.LocalDateTime");
            backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        } else {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
    }

    private Map<String, Object> initParams(HgDataModelOperation dataModelOperation, HgBaseDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) throws LcdpException {
        Map<String, Object> flagDeleteParams = dataModelOperation.getParams();
        List<HgDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i).getId().equals(dataModelOperation.getParams().get("mainId"))) {
                flagDeleteParams.put("mainId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (fields.get(i).getId().equals(dataModelOperation.getParams().get("pId"))) {
                flagDeleteParams.put("pId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (!HussarUtils.isNotEmpty((Object)fields.get(i).getFill()) || !fields.get(i).getFill().equals("primary")) continue;
            flagDeleteParams.put("mainName", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
        }
        flagDeleteParams.put("table", dataModelBaseDTO);
        flagDeleteParams.put("returnValue", dataModelBaseDTO.getEntityName());
        flagDeleteParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        flagDeleteParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u6279\u91cf\u5220\u9664");
            flagDeleteParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return flagDeleteParams;
    }
}

