/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.visitor.base;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgOperationVisitor;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.function.render.HgBaseRender;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HIGHGOBASEDeleteBatch")
public class HgDeleteListCodeVisitor
implements HgOperationVisitor<HgBaseDataModel, HgBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(HgDeleteListCodeVisitor.class);
    public static final String OPERATION_NAME = "HIGHGOBASEDeleteBatch";

    @Override
    public void visit(HgBackCtx<HgBaseDataModel, HgBaseDataModelDTO> backCtx, HgDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        HgBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        HgDataModelFieldDto keyFieldDto = dataModelBaseDTO.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            logger.error("\u6a21\u578b\u672a\u8bbe\u7f6e\u4e3b\u952e");
            return;
        }
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        String controllerPath = "template/hg/backcode/deletelist/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/hg/backcode/deletelist/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/hg/backcode/deletelist/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5220\u9664");
        backCtx.addApi(modelId, HgBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(HgBackCtx<HgBaseDataModel, HgBaseDataModelDTO> backCtx, String modelId, HgBaseDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "java.util.Arrays");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "org.springframework.beans.factory.annotation.Autowired");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
    }

    private Map<String, Object> initParams(HgDataModelOperation dataModelOperation, HgBaseDataModelDTO dataModelBaseDTO) throws LcdpException {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        List<HgDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i).getId().equals(dataModelOperation.getParams().get("mainId"))) {
                controllerParams.put("mainId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (fields.get(i).getId().equals(dataModelOperation.getParams().get("pId"))) {
                controllerParams.put("pId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (!HussarUtils.isNotEmpty((Object)fields.get(i).getFill()) || !fields.get(i).getFill().equals("primary")) continue;
            controllerParams.put("mainName", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
        }
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u6279\u91cf\u7269\u7406\u5220\u9664");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

