/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.element.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgEnclosure;
import com.jxdinfo.hussar.formdesign.hg.function.HgRender;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.relationship.HgRelationshipBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.util.HgDataModelUtil;
import com.jxdinfo.hussar.formdesign.hg.util.HgModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HgTaskMsDataModel
extends HgMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(HgTaskMsDataModel.class);
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    public static final String TASK_KEY = "task";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private HgBaseDataModel task;
    private List<HgDataModelField> flowFields;

    public List<HgDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<HgDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HIGHGO.TASK_MASTER_SLAVE", HgTaskMsDataModel.class);
    }

    public HgBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(HgBaseDataModel task) {
        this.task = task;
    }

    @Override
    public HgTaskMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HgTaskMsDataModel hgTaskMsDataModel;
        try {
            ArrayList<HgDataModelField> fieldList = new ArrayList<HgDataModelField>();
            hgTaskMsDataModel = (HgTaskMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), HgTaskMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                HgDataModelBase master = HgDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(hgTaskMsDataModel.getName() + "Master");
                hgTaskMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<HgDataModelBase> slaveTables = new ArrayList<HgDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    HgDataModelBase slaveTable = HgDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (HgRelationshipBase relationship : hgTaskMsDataModel.getRelationships()) {
                    if (relationship.getMasterTableId().equals(hgTaskMsDataModel.task.getId())) continue;
                    HgDataModelBase dataModelBase = slaveTables.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)relationship.getSlaveTableId())).findFirst().orElseGet(HgBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    HgDataModelField hgDataModelField = new HgDataModelField();
                    hgDataModelField.setId(UUID.randomUUID().toString());
                    hgDataModelField.setName(dataModelBase.getName());
                    hgDataModelField.setComment(dataModelBase.getComment());
                    hgDataModelField.setSourceDataModelId(dataModelBase.getId());
                    hgDataModelField.setDataType("array");
                    fieldList.add(hgDataModelField);
                }
                hgTaskMsDataModel.setSlaveTables(slaveTables);
            }
            hgTaskMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return hgTaskMsDataModel;
    }

    @Override
    public HgEnclosure<HgDataModelBase> enclosure() throws LcdpException {
        return HgModelBeanUtil.getEnclosureBean("HIGHGO", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public HgRender<HgDataModelBase, HgDataModelBaseDTO> render() throws LcdpException {
        return HgModelBeanUtil.getRenderBean("HIGHGO", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<HgDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<HgDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<HgDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<HgDataModelField>> contrastVOS = this.task.modelContrastTable((FieldsContrastParam<HgDataModelField>)fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable((FieldsContrastParam<HgDataModelField>)fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<HgDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.addAll(super.checkTableContrast(modelId).getDetails());
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        this.task.updateIndexForSystemTask(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public Boolean updateIndex(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return this.task.updateIndexForSystemTask(fieldsContrastParam);
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.getMasterTable().getId(), "T2");
        List<HgRelationshipBase> relationships = super.getRelationships();
        if (ToolUtil.isNotEmpty(relationships) && !relationships.isEmpty()) {
            for (int i = 0; i < relationships.size(); ++i) {
                HgRelationshipBase relationship = relationships.get(i);
                if (relationship.getSlaveTableId().equals(super.getId())) continue;
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> backCtx) throws LcdpException {
        HgModelBeanUtil.getCustomOperationBean("HIGHGO", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

