/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.processor;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.hg.code.HgCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgModelFunction;
import com.jxdinfo.hussar.formdesign.hg.function.HgOperationVisitor;
import com.jxdinfo.hussar.formdesign.hg.function.HgRender;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.result.HgCodeResult;
import com.jxdinfo.hussar.formdesign.hg.util.HgCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.hg.util.HgDataModelUtil;
import com.jxdinfo.hussar.formdesign.hg.util.HgModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HgModelProcessor
implements DataModelProcessor<HgCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(HgModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"HIGHGO", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<HgCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> backCtx = this.getHgBackCtx(publishCtx);
        HgModelProcessor.init(backCtx, dataModelBase);
        HgModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> getHgBackCtx(PublishCtx<HgCodeResult> publishCtx) {
        HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> backCtx = new HgBackCtx<HgDataModelBase, HgDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        HgModelFunction currentFunction = HgModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        HgDataModelBase currentModelBase = HgDataModelUtil.transfer(dataModelBase);
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, HgDataModelBaseDTO> useDtoMap = new HashMap<String, HgDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> backCtx, PublishCtx<HgCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        HgModelProcessor.visit(backCtx);
        HgModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        HgDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        HgDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PageInfoNode pageInfoNode = null;
        if (backCtx.getUseDataModelBase().getIsPublishResource()) {
            pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        }
        for (HgDataModelOperation operation : useDataModelBase.getOperations()) {
            if ("AsyncVerify".equals(operation.getType())) {
                operation.setType("UniqueVerify");
                operation.setName("uniqueVerify");
            }
            HgOperationVisitor<HgDataModelBase, HgDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("HIGHGO", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            try {
                backCtx.getModelFunction().accept(visitor, backCtx, operation);
            }
            catch (Exception var) {
                logger.error("\u6a21\u578b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{} \u6e32\u67d3\u5931\u8d25\uff0c\u6e32\u67d3\u8def\u5f84\uff1a{}", new Object[]{useDataModelBase.getComment(), operation.getName(), visitor.getClass().getName()});
                throw new LcdpException(var, String.format("\u6a21\u578b%s\u6e32\u67d3\u5931\u8d25\uff0c\u5f02\u5e38\uff1a%s", useDataModelBase.getComment(), var.getMessage()));
            }
            if (!backCtx.getUseDataModelBase().getIsPublishResource() || !ToolUtil.isNotEmpty((Object)pageInfoNode)) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
        useDataModelBase.customOption(backCtx);
    }

    public static void render(HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> backCtx, PublishCtx<HgCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        HgRender<HgDataModelBase, HgDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<HgCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(HgCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
        if (HussarUtils.isNotEmpty((Object)backCtx.getParams())) {
            backCtx.getParams().keySet().forEach(key -> {
                if (ToolUtil.isEmpty((Object)publishCtx.getParams())) {
                    publishCtx.addParams(new HashMap());
                }
                publishCtx.getParams().putIfAbsent(key, backCtx.getParam((String)key));
            });
        }
    }
}

