/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.element.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.function.HgEnclosure;
import com.jxdinfo.hussar.formdesign.hg.function.HgRender;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.relationship.HgRelationshipBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.util.HgDataModelUtil;
import com.jxdinfo.hussar.formdesign.hg.util.HgModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HgFlowMsDataModel
extends HgMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(HgFlowMsDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<HgDataModelField> flowFields;

    public List<HgDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<HgDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HIGHGO.FLOW_MASTER_SLAVE", HgFlowMsDataModel.class);
    }

    @Override
    public HgFlowMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HgFlowMsDataModel hgFlowMsDataModel;
        try {
            ArrayList<HgDataModelField> fieldList = new ArrayList<HgDataModelField>();
            hgFlowMsDataModel = (HgFlowMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), HgFlowMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                HgDataModelBase master = HgDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(hgFlowMsDataModel.getName() + "Master");
                hgFlowMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<HgDataModelBase> slaveTables = new ArrayList<HgDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    HgDataModelBase slaveTable = HgDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (HgRelationshipBase relationship : hgFlowMsDataModel.getRelationships()) {
                    HgDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(HgBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    HgDataModelField hgDataModelField = new HgDataModelField();
                    hgDataModelField.setId(UUID.randomUUID().toString());
                    hgDataModelField.setName(dataModelBase.getName());
                    hgDataModelField.setComment(dataModelBase.getComment());
                    hgDataModelField.setSourceDataModelId(dataModelBase.getId());
                    hgDataModelField.setDataType("array");
                    fieldList.add(hgDataModelField);
                }
                hgFlowMsDataModel.setSlaveTables(slaveTables);
            }
            hgFlowMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return hgFlowMsDataModel;
    }

    @Override
    public HgEnclosure<HgDataModelBase> enclosure() throws LcdpException {
        return HgModelBeanUtil.getEnclosureBean("HIGHGO", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public HgRender<HgDataModelBase, HgDataModelBaseDTO> render() throws LcdpException {
        return HgModelBeanUtil.getRenderBean("HIGHGO", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<HgDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<HgDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<HgDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable((FieldsContrastParam<HgDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<HgDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws Exception {
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

