/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.visitor.view;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgOperationVisitor;
import com.jxdinfo.hussar.formdesign.hg.function.element.view.HgViewDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.view.HgViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.hgQueryDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.querycondition.HgQueryCondition;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.querycondition.HgQueryConditionField;
import com.jxdinfo.hussar.formdesign.hg.util.HgBackRenderUtil;
import com.jxdinfo.hussar.formdesign.hg.util.HgDataModelUtil;
import com.jxdinfo.hussar.formdesign.hg.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.hg.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HIGHGOVIEWDataDisplay")
public class HgViewDataDisplayVisitor
implements HgOperationVisitor<HgViewDataModel, HgViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(HgViewDataDisplayVisitor.class);
    public static final String OPERATION_NAME = "HIGHGOVIEWDataDisplay";

    @Override
    public void visit(HgBackCtx<HgViewDataModel, HgViewDataModelDTO> backCtx, HgDataModelOperation dataModelOperation) throws LcdpException {
        String visitorName = OPERATION_NAME;
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        HgViewDataModel useDataModelView = backCtx.getUseDataModelBase();
        String modelId = useDataModelView.getId();
        HgViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelViewDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, useDataModelView, dataModelViewDTO, controllerParams);
        controllerParams.put("table", dataModelViewDTO);
        controllerParams.put("returnValue", dataModelViewDTO.getEntityName());
        controllerParams.put("url", url);
        this.renderPageVo(backCtx, modelId, dataModelViewDTO, controllerParams);
        String relateFieldName = String.valueOf(controllerParams.get("relateField"));
        String relateField = dataModelViewDTO.getFieldCapitalName(relateFieldName);
        List<HgDataModelFieldDto> fields = dataModelViewDTO.getFields();
        for (HgDataModelFieldDto field : fields) {
            if (!relateFieldName.equals(field.getPropertyName())) continue;
            controllerParams.put("fieldType", field.getType());
            controllerParams.put("relateFieldType", field.getColumnType().getType());
            if ("string".equals(field.getType())) {
                controllerParams.put("isTypeConversion", false);
                break;
            }
            controllerParams.put("isTypeConversion", true);
            break;
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelViewDTO.getComment() + "\u6570\u636e\u5c55\u793a");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        String controllerPath = "template/hg/backcode/datadisplay/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelViewDTO, isSelectCondition);
        backCtx.addControllerInversion(modelId, dataModelViewDTO.getServiceName());
        String servicePath = "template/hg/backcode/datadisplay/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        String serviceImplPath = "template/hg/backcode/datadisplay/service_impl.ftl";
        controllerParams.put("capitalRelateField", relateField);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, dataModelViewDTO.getMapperName());
            String mapperPath = "template/hg/backcode/datadisplay/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/hg/backcode/datadisplay/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", isSelectCondition ? "postJson" : "postForm", url, "\u6570\u636e\u5c55\u793a");
        backCtx.addApi(modelId, HgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(HgBackCtx<HgViewDataModel, HgViewDataModelDTO> backCtx, String modelId, HgViewDataModelDTO dataModelBaseDTO, boolean isSelectCondition) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "java.util.Arrays");
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        } else {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
            backCtx.addControllerImport(modelId, "java.util.Arrays");
        }
    }

    private void renderPageVo(HgBackCtx<HgViewDataModel, HgViewDataModelDTO> backCtx, String modelId, HgViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams) {
        HgDataModelUtil.addQueryPageViewVo(dataModelViewDTO);
        String voEntityName = dataModelViewDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelViewDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private boolean renderSelect(HgBackCtx<HgViewDataModel, HgViewDataModelDTO> backCtx, HgDataModelOperation dataModelOperation, String modelId, HgViewDataModel useDataModelBase, HgViewDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        String inValuesSql = this.getInValuesSql(dataModelBaseDTO, dataModelOperation);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            HgQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
            ArrayList<String> likeQueryFields = new ArrayList<String>();
            for (HgQueryConditionField queryConditionField : queryCondition.getFields()) {
                String symbol = queryConditionField.getSymbol();
                if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
                likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
            }
            controllerParams.put("likeQueryFields", likeQueryFields);
            if (Optional.ofNullable(queryCondition).map(HgQueryCondition::getFields).isPresent() && !queryCondition.getFields().isEmpty()) {
                DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
                hgQueryDTO queryDTO = HgDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
                dataModelBaseDTO.addQueryDto(queryDTO);
                String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), inValuesSql, dataModelBaseDTO, new HashMap<String, String>());
                controllerParams.put("QueryObj", queryDTO.getEntityName());
                controllerParams.put("queryObj", queryDTO.getName());
                controllerParams.put("whereSql", finalWhereSql);
                isSelectCondition = true;
                controllerParams.put("isSelectCondition", true);
                String importInfo = queryDTO.getImportInfo();
                backCtx.addControllerImport(modelId, importInfo);
                backCtx.addServiceImport(modelId, importInfo);
                backCtx.addServiceImplImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            }
        }
        return isSelectCondition;
    }

    private String getInValuesSql(HgViewDataModelDTO dataModelBaseDTO, HgDataModelOperation dataModelOperation) {
        String template = "<if test=\"inValues != null and inValues.size > 0\">\n ${T_ALIAS}.${REAL_FIELD} in\n    <foreach collection=\"inValues\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>\n";
        String entityAttr = (String)dataModelOperation.getParams().get("relateField");
        String fieldBaseName = dataModelBaseDTO.getFieldBaseName(entityAttr);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{fieldBaseName})) {
            return template.replace("${T_ALIAS}", "t").replace("${REAL_FIELD}", fieldBaseName);
        }
        return "";
    }
}

