/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgOperationVisitor;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.hgQueryDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.function.visitor.constant.HgConstUtil;
import com.jxdinfo.hussar.formdesign.hg.function.visitor.masterslave.util.HgMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.hg.util.HgBackRenderUtil;
import com.jxdinfo.hussar.formdesign.hg.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HIGHGOFLOW_MASTER_SLAVEFormQuery")
public class HgMsFlowFormQueryVisitor
implements HgOperationVisitor<HgFlowMsDataModel, HgFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(HgMsFlowFormQueryVisitor.class);
    public static final String OPERATION_NAME = "HIGHGOFLOW_MASTER_SLAVEFormQuery";

    @Override
    public void visit(HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx, HgDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        HgFlowMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        HgDataModelBase masterTable = dataModelBase.getMasterTable();
        HgFlowMsDataModelDTO hgFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = hgFlowMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, HgDataModelBase> dataModelBaseMap = hgFlowMsDataModelDTO.getDataModelBaseMap();
        Map<String, HgDataModelBaseDTO> dataModelDtoMap = hgFlowMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        Map slaveTablePlusSave = (Map)operation.getParams().get("slaveTablePlusSave");
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        controllerParams.put("table", hgFlowMsDataModelDTO);
        controllerParams.put("returnValue", hgFlowMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("isPlusQuery", false);
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            Map<String, String> slaveQueryNames;
            for (HgDataModelBase slaveTable : dataModelBase.getSlaveTables()) {
                capitalNameList.put(slaveTable.getName(), HgMasterSlaveUtil.getCapitalName(slaveTable.getName()));
            }
            controllerParams.put("boolFields", hgFlowMsDataModelDTO.getFields().stream().filter(o -> "boolean".equals(o.getType())).collect(Collectors.toList()));
            controllerParams.put("capitalNameList", capitalNameList);
            controllerParams.put("returnIncrementValue", hgFlowMsDataModelDTO.getEntityName() + "FormVO");
            controllerParams.put("slaveTable", HgMsFlowFormQueryVisitor.getSlaveArrayTables(hgFlowMsDataModelDTO, dataModelBase));
            controllerParams.put("primaryField", hgFlowMsDataModelDTO.getKeyPropertyName());
            controllerParams.put("pageDTO", hgFlowMsDataModelDTO.getEntityName() + "PageDTO");
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                controllerParams.put("isPlusQuery", true);
                break;
            }
            if (ToolUtil.isNotEmpty(slaveQueryNames = HgMsFlowFormQueryVisitor.getSlaveQueryName(dataModelBase))) {
                controllerParams.put("slaveQueryNames", slaveQueryNames);
            }
            HgDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
            backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
            backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
            HgMsFlowFormQueryVisitor.addFormVO(hgFlowMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
            HgMsFlowFormQueryVisitor.addFormQueryDto(hgFlowMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(hgFlowMsDataModelDTO.getComment() + "\u8868\u5355\u67e5\u8be2");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/hg/masterslavebackcode/get/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, hgFlowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, hgFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, hgFlowMsDataModelDTO.getServiceName());
        String servicePath = "template/hg/masterslavebackcode/get/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, hgFlowMsDataModelDTO.getImportInfo().get("Entity"));
        String serviceImplPath = "template/hg/masterslavebackcode/get/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, hgFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, hgFlowMsDataModelDTO.getImportInfo().get("Mapper"));
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        }
        if (ToolUtil.isNotEmpty((Object)hgFlowMsDataModelDTO.isHasTranslate()) && hgFlowMsDataModelDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addServiceImplInversion(modelId, hgFlowMsDataModelDTO.getMapperName());
        String mapperPath = "template/hg/masterslavebackcode/get/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, hgFlowMsDataModelDTO.getImportInfo().get("Entity"));
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        String finalReturn = SqlReturnUtil.renderReturn(dataModelBase, aliasMap);
        controllerParams.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(dataModelBase, dataModelBaseMap);
        controllerParams.put("relation", finalRelation);
        controllerParams.put("quoteModel", HgConstUtil.TRUE);
        String whereTemplate = "where ${T}.${primary} = #{id}";
        String masterTableId = masterTable.getId();
        HgDataModelBaseDTO hgDataModelBaseDTO = dataModelDtoMap.get(masterTableId);
        if (ToolUtil.isNotEmpty((Object)hgDataModelBaseDTO)) {
            controllerParams.put("whereSql", whereTemplate.replace("${T}", aliasMap.get(masterTableId)).replace("${primary}", hgDataModelBaseDTO.getKeyField().getName()));
        }
        if (ToolUtil.isNotEmpty((Object)controllerParams.get("customizeSql"))) {
            backCtx.addXmlCode(modelId, (String)controllerParams.get("customizeSql"));
        } else {
            String xmlPath = "template/hg/masterslavebackcode/get/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "get", url, "\u8868\u5355\u67e5\u8be2");
        backCtx.addApi(modelId, HgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        if (((Boolean)controllerParams.get("isPlusQuery")).booleanValue()) {
            ApiGenerateInfo apiGenerateInfoPlus = new ApiGenerateInfo(operation.getName() + "Plus", "data", "postJson", url + "Plus", "\u589e\u91cf\u8868\u5355\u67e5\u8be2");
            backCtx.addApi(modelId, HgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfoPlus));
        }
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static void addFormVO(HgMsDataModelDTO dataModelBaseDTO, HgMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx) {
        hgQueryDTO queryDTO = new hgQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/hg/backcode/code/formVo.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        params.put("voImport", dataModelBaseDTO.getPackageInfo().get("VO"));
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("Entity"));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("masterTable", dataModelBaseDTO.getFields());
        params.put("slaveTable", HgMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "FormVO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "FormVO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("VO"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importVOPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + queryDTO.getEntityName();
        dataModelBaseDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importVOPath);
        backCtx.addServiceImport(modelId, importVOPath);
        backCtx.addServiceImplImport(modelId, importVOPath);
    }

    private static void addFormQueryDto(HgMsDataModelDTO dataModelBaseDTO, HgMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, HgBackCtx<HgFlowMsDataModel, HgFlowMsDataModelDTO> backCtx) {
        hgQueryDTO queryDTO = new hgQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/hg/backcode/code/formDto.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("slaveTable", HgMsFlowFormQueryVisitor.getSlaveArrayTables(dataModelBaseDTO, dataModelBase));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("dto"));
        params.put("queryDto", queryDTO);
        params.put("priType", dataModelBaseDTO.getKeyField().getPropertyType());
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "PageDTO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "PageDTO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
        String importDTOPath = dataModelBaseDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private static List<HgDataModelBase> getSlaveArrayTables(HgMsDataModelDTO dataModelBaseDTO, HgMsDataModel dataModelBase) {
        CopyOnWriteArrayList<HgDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<HgDataModelBase>(dataModelBase.getSlaveTables());
        for (HgDataModelBase slaveArrayTable : slaveArrayTables) {
            for (SourcePackageInfo sourcePackageInfo : dataModelBaseDTO.getSourcePackageInfos()) {
                if (!"object".equals(sourcePackageInfo.getDataType()) || !slaveArrayTable.getName().equals(sourcePackageInfo.getObjectEnName())) continue;
                slaveArrayTables.remove(slaveArrayTable);
            }
        }
        return slaveArrayTables;
    }

    private static Map<String, String> getSlaveQueryName(HgFlowMsDataModel dataModelBase) {
        List<HgDataModelOperation> operations = dataModelBase.getOperations();
        HashMap<String, String> slaveQueryNameMap = new HashMap<String, String>();
        List<HgDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        if (ToolUtil.isNotEmpty(slaveTables)) {
            block0: for (HgDataModelOperation operation : operations) {
                if (!ToolUtil.isNotEmpty((Object)operation) || !"SlaveQuery".equals(operation.getType()) || !ToolUtil.isNotEmpty((Object)operation.getName()) || !ToolUtil.isNotEmpty(operation.getParams()) || !ToolUtil.isNotEmpty((Object)operation.getParams().get("slaveModelId"))) continue;
                String slaveModelId = operation.getParams().get("slaveModelId").toString();
                for (HgDataModelBase slaveTable : slaveTables) {
                    if (!ToolUtil.isNotEmpty((Object)slaveTable) || !ToolUtil.isNotEmpty((Object)slaveModelId) || !slaveModelId.equals(slaveTable.getId())) continue;
                    slaveQueryNameMap.put(operation.getParams().get("slaveModelId").toString(), operation.getName());
                    continue block0;
                }
            }
        }
        return slaveQueryNameMap;
    }
}

