/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.element.task;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgEnclosure;
import com.jxdinfo.hussar.formdesign.hg.function.HgRender;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.relationship.HgRelationshipBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.util.HgModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class HgTaskDataModel
extends HgBaseDataModel {
    public static final String FUNCTION_TYPE = "TASK";
    public static final String TASK_KEY = "task";
    public static final String BUSINESS_ID = "businessId";
    private HgBaseDataModel task;
    private List<HgRelationshipBase> relationships;
    private List<HgDataModelField> flowFields;

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HIGHGO.TASK", HgTaskDataModel.class);
    }

    public HgBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(HgBaseDataModel task) {
        this.task = task;
    }

    public List<HgRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<HgRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<HgDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<HgDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    public HgTaskDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HgTaskDataModel hgTaskDataModel;
        try {
            hgTaskDataModel = (HgTaskDataModel)JSONObject.parseObject((String)jsonObject.toString(), HgTaskDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return hgTaskDataModel;
    }

    @Override
    public HgEnclosure<HgDataModelBase> enclosure() throws LcdpException {
        return HgModelBeanUtil.getEnclosureBean("HIGHGO", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public HgRender<HgDataModelBase, HgDataModelBaseDTO> render() throws LcdpException {
        return HgModelBeanUtil.getRenderBean("HIGHGO", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<HgDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<HgDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<HgDataModelField>> modelContrastTable(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<HgDataModelField>> contrastVOS = this.task.modelContrastTable(fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable(fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModelIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTableIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<HgDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.add(super.checkTableContrast(modelId).getDetails().get(0));
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "t");
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(HgBackCtx<HgDataModelBase, HgDataModelBaseDTO> backCtx) throws LcdpException {
        HgModelBeanUtil.getCustomOperationBean("HIGHGO", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }
}

