/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.function.HgEnclosure;
import com.jxdinfo.hussar.formdesign.hg.function.HgRender;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.relationship.HgRelationshipBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.querycondition.HgQueryCondition;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.querycondition.HgQueryObject;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.sortcondition.HgSortCondition;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.sortcondition.HgSortConditionField;
import com.jxdinfo.hussar.formdesign.hg.util.HgDataModelUtil;
import com.jxdinfo.hussar.formdesign.hg.util.HgModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HgMsDataModel
extends HgDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(HgMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<HgQueryCondition> queryConditions;
    private List<HgQueryObject> queryObject;
    private HgDataModelBase masterTable;
    private List<HgDataModelBase> slaveTables;
    private List<HgRelationshipBase> relationships;
    private boolean logicallyDelete;
    private List<HgSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HIGHGO.MASTER_SLAVE", HgMsDataModel.class);
    }

    @Override
    public HgMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HgMsDataModel hgMsDataModel;
        try {
            ArrayList<HgDataModelField> fieldList = new ArrayList<HgDataModelField>();
            hgMsDataModel = (HgMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), HgMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                HgDataModelBase master = HgDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(hgMsDataModel.getName() + "Master");
                hgMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<HgDataModelBase> slaveTables = new ArrayList<HgDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    HgDataModelBase slaveTable = HgDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (HgRelationshipBase relationship : hgMsDataModel.getRelationships()) {
                    HgDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(HgBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    HgDataModelField hgDataModelField = new HgDataModelField();
                    hgDataModelField.setId(UUID.randomUUID().toString());
                    hgDataModelField.setName(dataModelBase.getName());
                    hgDataModelField.setComment(dataModelBase.getComment());
                    hgDataModelField.setSourceDataModelId(dataModelBase.getId());
                    hgDataModelField.setDataType("array");
                    fieldList.add(hgDataModelField);
                }
                hgMsDataModel.setSlaveTables(slaveTables);
            }
            hgMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return hgMsDataModel;
    }

    @Override
    public HgEnclosure<HgDataModelBase> enclosure() throws LcdpException {
        return HgModelBeanUtil.getEnclosureBean("HIGHGO", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public HgRender<HgDataModelBase, HgDataModelBaseDTO> render() throws LcdpException {
        return HgModelBeanUtil.getRenderBean("HIGHGO", FUNCTION_TYPE, "RENDER");
    }

    public HgDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(HgDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<HgDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<HgDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<HgRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<HgRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<HgQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<HgQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<HgQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<HgQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<HgSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (HgSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (HgSortConditionField field : condition.getFields()) {
                    Map<String, String> fieldMap;
                    String fieldName;
                    if (HussarUtils.isEmpty((Object)field.getParentModelId())) {
                        field.setParentModelId(field.getFromModelIdSort());
                    }
                    HgDataModelBase dataModelBase = this.masterTable;
                    if (!this.masterTable.getId().equals(field.getFromModelIdSort())) {
                        for (HgDataModelBase modelBase : this.slaveTables) {
                            if (!modelBase.getId().equals(field.getFromModelIdSort())) continue;
                            dataModelBase = modelBase;
                            break;
                        }
                    }
                    if (HussarUtils.equals((Object)(fieldName = (fieldMap = dataModelBase.getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName))).get(field.getFromModelFieldIdSort())), (Object)field.getFromModelFieldSort())) continue;
                    field.setFromModelFieldSort(fieldName);
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<HgSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public HgQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (HgQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public HgSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (HgSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                HgRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<HgDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<HgDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<HgDataModelField>> tableContrastModel(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<HgDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<HgDataModelField>> modelContrastTable(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<HgDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            if (!HussarUtils.isEmpty(map.get(this.slaveTables.get(i).getSourceDataModelName()))) continue;
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
            map.put(this.slaveTables.get(i).getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<HgDataModelField> fieldsContrastParam) throws Exception {
        String sql = this.masterTable.copyTableByModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            sql = sql + this.slaveTables.get(i).copyTableByModel(fieldsContrastParam);
        }
        return sql;
    }

    public HgDataModelField getDeleteFlag() {
        return this.getMasterTable().getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public HgDataModelField getPrimaryKey() {
        return this.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        List<HgDataModelBase> slaveTables = this.getSlaveTables();
        for (HgDataModelBase slaveTable : slaveTables) {
            HgDataModelField hgDataModelField = slaveTable.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(new HgDataModelField());
            HashMap<String, Object> val = new HashMap<String, Object>();
            val.put("comment", slaveTable.getComment());
            val.put("primary", hgDataModelField.getName());
            val.put("fields", slaveTable.getFields());
            boolean association = this.getRelationships().stream().anyMatch(relationship -> relationship.getRelateModelType().equals(ASSOCIATION) && relationship.getSlaveTableId().equals(slaveTable.getId()));
            val.put(ASSOCIATION, association);
            map.put(slaveTable.getId(), val);
        }
        return map;
    }
}

