/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.provider;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.function.HgModelFunction;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.masterslave.HgMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.task.HgTaskDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.task.HgTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBase;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.operation.HgDataModelOperation;
import com.jxdinfo.hussar.formdesign.hg.service.HgWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.hg.util.HgModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HgModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(HgModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"HIGHGO", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            return FileUtil.posixPath((String[])new String[]{apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
        if (ToolUtil.isEmpty((Object)dataModelJson)) {
            return "";
        }
        HgModelFunction modelFunction = HgModelBeanUtil.getFunctionModelVisitorBean(dataModelJson.getString("functionType"));
        HgDataModelBase lrDataModelBase = modelFunction.parseDataModel(dataModelJson);
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(HgDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        HgModelFunction modelFunction = HgModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        HgDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (HgDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return new HgWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId, oldVersion, organId, newOrganId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        HgModelFunction modelFunction = HgModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        HgDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> hgDataModelFields = new ArrayList<DataModelFieldBase>();
        List<HgDataModelField> fields = dataModelBase.getFields();
        if (ToolUtil.isNotEmpty(fields)) {
            hgDataModelFields.addAll(fields);
        } else {
            List<HgDataModelBase> slaveTables = null;
            HgDataModelBase masterTable = new HgBaseDataModel();
            if (modelFunction instanceof HgFlowMsDataModel) {
                slaveTables = ((HgFlowMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((HgFlowMsDataModel)dataModelBase).getMasterTable();
            } else if (modelFunction instanceof HgMsDataModel) {
                slaveTables = ((HgMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((HgMsDataModel)dataModelBase).getMasterTable();
            }
            hgDataModelFields.addAll(masterTable.getFields());
            if (ToolUtil.isNotEmpty(slaveTables)) {
                for (HgDataModelBase slaveTable : slaveTables) {
                    hgDataModelFields.addAll(slaveTable.getFields());
                }
            }
        }
        if (modelFunction instanceof HgTaskDataModel) {
            hgDataModelFields.addAll(((HgTaskDataModel)dataModelBase).getTask().getFields());
        } else if (modelFunction instanceof HgTaskMsDataModel) {
            hgDataModelFields.addAll(((HgTaskMsDataModel)dataModelBase).getTask().getFields());
        }
        return hgDataModelFields;
    }

    public void delete(String modelId) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        HgModelFunction modelFunction = HgModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        HgDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return model.getSlaveModelInfo();
    }
}

